/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Assert;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.util.SimpleAddress;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class ObjectUtilTest
extends TestCase {
    public void testBuildObject() {
        SimpleAddress sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        SimpleAddress targetAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress);
        ObjectUtilTest.assertEquals((Object)targetAddress, (Object)sourceAddress);
        targetAddress = new SimpleAddress(null, null, null, 9999);
        propertyList.clear();
        propertyList.add("street");
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress, propertyList);
        ObjectUtilTest.assertEquals((String)sourceAddress.getStreet(), (String)targetAddress.getStreet());
        Assert.assertNotEquals((Object)targetAddress, (Object)sourceAddress);
        targetAddress = new SimpleAddress(null, null, null, 9999);
        Object[] sourceAddressArray = new String[]{"1000 Main Street", "Source City", "Kuali", "10000"};
        propertyList.clear();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        ObjectUtil.buildObject((Object)targetAddress, (Object[])sourceAddressArray, propertyList);
        Assert.assertNotEquals((Object)targetAddress, (Object)sourceAddress);
        propertyList.add("zip");
        ObjectUtil.buildObject((Object)targetAddress, (Object[])sourceAddressArray, propertyList);
        ObjectUtilTest.assertEquals((Object)targetAddress, (Object)sourceAddress);
    }

    public void testCompareObject() {
        SimpleAddress sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress targetAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtilTest.assertFalse((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ObjectUtilTest.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = sourceAddress;
        ObjectUtilTest.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress);
        ObjectUtilTest.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        sourceAddress.setZip(2000);
        ObjectUtilTest.assertFalse((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        propertyList.remove("zip");
        ObjectUtilTest.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
    }

    public void testBuildPropertyMap() {
        SimpleAddress address = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        Map propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        ObjectUtilTest.assertEquals((Object)address.getStreet(), propertyMap.get("street"));
        ObjectUtilTest.assertEquals((Object)address.getCity(), propertyMap.get("city"));
        ObjectUtilTest.assertEquals((Object)address.getState(), propertyMap.get("state"));
        ObjectUtilTest.assertFalse((boolean)address.getZip().equals(propertyMap.get("zip")));
        propertyList.add("zip");
        propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        ObjectUtilTest.assertEquals((Object)address.getZip(), propertyMap.get("zip"));
    }

    public void testBuildPropertyMapWithBlankValues() {
        SimpleAddress address = new SimpleAddress("", "", null, 1000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        Map propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        ObjectUtilTest.assertNull(propertyMap.get("street"));
        ObjectUtilTest.assertNull(propertyMap.get("city"));
        ObjectUtilTest.assertNull(propertyMap.get("state"));
        ObjectUtilTest.assertEquals((Object)address.getZip(), propertyMap.get("zip"));
        ObjectUtilTest.assertEquals((int)1, (int)propertyMap.size());
    }

    public void testConvertLineToBusinessObjectBasedOnDeliminatorAndKeyList() {
        String delim = ";";
        String line = "1000 Main Street" + delim + "Source City" + delim + "Kuali" + delim + "10000";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)line, (String)delim, propertyList);
        ObjectUtilTest.assertEquals((String)address.getStreet(), (String)"1000 Main Street");
        ObjectUtilTest.assertEquals((String)address.getCity(), (String)"Source City");
        ObjectUtilTest.assertEquals((String)address.getState(), (String)"Kuali");
        ObjectUtilTest.assertEquals((Object)address.getZip(), (Object)new Integer(10000));
    }

    public void testConvertLineToBusinessObjectBasedOnDeliminatorAndKeyString() {
        String delim = ";";
        String line = "1000 Main Street" + delim + "Source City" + delim + "Kuali" + delim + "10000" + delim;
        String fieldNames = "street" + delim + "city" + delim + "state" + delim + "zip" + delim;
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)line, (String)delim, (String)fieldNames);
        ObjectUtilTest.assertEquals((String)"1000 Main Street", (String)address.getStreet());
        ObjectUtilTest.assertEquals((String)"Source City", (String)address.getCity());
        ObjectUtilTest.assertEquals((String)"Kuali", (String)address.getState());
        ObjectUtilTest.assertEquals((Object)new Integer(10000), (Object)address.getZip());
    }

    public void testConvertLineToBusinessObjectAtCompressedFormat() {
        String delim = ";";
        String line = "" + delim + "" + delim + "" + delim + "" + delim;
        String fieldNames = "street" + delim + "city" + delim + "state" + delim + "zip" + delim;
        SimpleAddress address = new SimpleAddress("", "", "", null);
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)line, (String)delim, (String)fieldNames);
        ObjectUtilTest.assertNull((Object)address.getStreet());
        ObjectUtilTest.assertNull((Object)address.getCity());
        ObjectUtilTest.assertNull((Object)address.getState());
        ObjectUtilTest.assertNull((Object)address.getZip());
    }

    public void testConvertLineToBusinessObjectBasedOnFieldLength() {
        int[] fieldLength = new int[]{6, 4, 5, 5};
        String line = "StreetCityState10000";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)line, (int[])fieldLength, propertyList);
        ObjectUtilTest.assertEquals((String)"Street", (String)address.getStreet());
        ObjectUtilTest.assertEquals((String)"City", (String)address.getCity());
        ObjectUtilTest.assertEquals((String)"State", (String)address.getState());
        ObjectUtilTest.assertEquals((Object)new Integer(10000), (Object)address.getZip());
    }

    public void testConvertLineToBusinessObjectBasedOnFieldLength_WithWhiteSpace() {
        int[] fieldLength = new int[]{8, 6, 7, 7};
        String line = "Street  City  State  10000  ";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)line, (int[])fieldLength, propertyList);
        ObjectUtilTest.assertEquals((String)"Street", (String)address.getStreet());
        ObjectUtilTest.assertEquals((String)"City", (String)address.getCity());
        ObjectUtilTest.assertEquals((String)"State", (String)address.getState());
        ObjectUtilTest.assertEquals((Object)new Integer(10000), (Object)address.getZip());
    }

    public void testSplit() {
        String delim = ";";
        String line = "" + delim + "" + delim + "" + delim + "" + delim;
        List tokens = ObjectUtil.split((String)line, (String)delim);
        ObjectUtilTest.assertEquals((int)4, (int)tokens.size());
        line = delim + line;
        tokens = ObjectUtil.split((String)line, (String)delim);
        ObjectUtilTest.assertEquals((int)5, (int)tokens.size());
    }

    public void testValueOfInteger() {
        String integerType = "Integer";
        String[] value = new String[]{"-100", "0", "100", "", "12.9", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            Integer expectedValue = tempvalue != null ? Integer.valueOf(expected[i]) : null;
            ObjectUtilTest.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)integerType, (String)value[i]));
        }
    }

    public void testValueOfKualiDecimal() {
        String type = "KualiDecimal";
        String[] value = new String[]{"-100.00", "0", "100", "100.00", "", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", "100", null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            KualiDecimal expectedValue = tempvalue != null ? new KualiDecimal(expected[i]) : null;
            ObjectUtilTest.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)type, (String)value[i]));
        }
    }

    public void testValueOfKualiInteger() {
        String type = "KualiInteger";
        String[] value = new String[]{"-100", "0", "100", "100.00", "", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            KualiInteger expectedValue = tempvalue != null ? new KualiInteger(expected[i]) : null;
            ObjectUtilTest.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)type, (String)value[i]));
        }
    }

    public void testValueOfDate() {
        String type = "Date";
        String[] value = new String[]{"2000-01-31", "2000/1/1", "1/1/2000", "", "bad value"};
        String[] expected = new String[]{"2000-01-31", null, null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            Date expectedValue = tempvalue != null ? Date.valueOf(expected[i]) : null;
            ObjectUtilTest.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)type, (String)value[i]));
        }
    }

    public void testValueOfTimestamp() {
        String type = "Timestamp";
        String[] value = new String[]{"2000-01-31 00:12:00.55", "2000-01-31", "2000/1/1", "1/1/2000", "", "bad value"};
        String[] expected = new String[]{"2000-01-31 00:12:00.55", "2000-01-31 00:00:00.0", null, null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            Timestamp expectedValue = tempvalue != null ? Timestamp.valueOf(expected[i]) : null;
            ObjectUtilTest.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)type, (String)value[i]));
        }
    }

    public void testHasNullValueField() {
        SimpleAddress sourceAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtilTest.assertTrue((boolean)ObjectUtil.hasNullValueField((Object)sourceAddress));
        sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000, new KualiDecimal(200000), new Date(1000000L));
        ObjectUtilTest.assertTrue((!ObjectUtil.hasNullValueField((Object)sourceAddress) ? 1 : 0) != 0);
    }

    public void testParseNestedAttribute() {
        String attributes = "laborObject.chartOfAccounts.chartOfAccountsCode";
        System.out.println(ObjectUtil.getNestedAttributeTypes(LedgerBalance.class, (String)attributes));
    }
}

