/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.gl.service.PreScrubberService;
import org.kuali.kfs.gl.service.ScrubberValidator;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.batch.service.LaborScrubberService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.sys.dataaccess.UniversityDateDao;
import org.kuali.kfs.sys.service.DocumentNumberAwareReportWriterService;
import org.kuali.kfs.sys.service.FlexibleOffsetAccountService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborScrubberServiceImpl implements LaborScrubberService {

    private static final Logger LOG = LogManager.getLogger();

    protected FlexibleOffsetAccountService flexibleOffsetAccountService;
    protected LaborOriginEntryService laborOriginEntryService;
    protected OriginEntryGroupService originEntryGroupService;
    protected DateTimeService dateTimeService;
    protected OffsetDefinitionService offsetDefinitionService;
    protected ObjectCodeService objectCodeService;
    protected ConfigurationService kualiConfigurationService;
    protected UniversityDateDao universityDateDao;
    protected PersistenceService persistenceService;
    protected ScrubberValidator scrubberValidator;
    protected LaborAccountingCycleCachingService laborAccountingCycleCachingService;
    protected PreScrubberService preScrubberService;
    protected DocumentNumberAwareReportWriterService llcpPreScrubberReportWriterService;

    protected DocumentNumberAwareReportWriterService laborMainReportWriterService;
    protected DocumentNumberAwareReportWriterService llcpMainReportWriterService;
    protected DocumentNumberAwareReportWriterService laborLedgerReportWriterService;
    protected DocumentNumberAwareReportWriterService llcpLedgerReportWriterService;
    protected ReportWriterService laborBadBalanceTypeReportWriterService;
    protected ReportWriterService laborErrorListingReportWriterService;
    protected DocumentNumberAwareReportWriterService laborGeneratedTransactionsReportWriterService;
    protected ReportWriterService laborDemergerReportWriterService;
    protected ParameterService parameterService;
    private ParameterEvaluatorService parameterEvaluatorService;

    protected String batchFileDirectoryName;

    public synchronized void scrubGroupReportOnly(String fileName, String documentNumber) {
        LOG.debug("scrubGroupReportOnly() started");

        // The logic for this was moved into another object because the process was written using
        // many instance variables which shouldn't be used for Spring services

        LaborScrubberProcess sp = new LaborScrubberProcess(flexibleOffsetAccountService,
                laborAccountingCycleCachingService, laborOriginEntryService, originEntryGroupService, dateTimeService,
                offsetDefinitionService, objectCodeService, kualiConfigurationService, universityDateDao,
                persistenceService, scrubberValidator, batchFileDirectoryName, llcpMainReportWriterService,
                llcpLedgerReportWriterService, laborBadBalanceTypeReportWriterService,
                laborErrorListingReportWriterService, laborGeneratedTransactionsReportWriterService,
                laborDemergerReportWriterService, preScrubberService, llcpPreScrubberReportWriterService,
                parameterService, parameterEvaluatorService);
        sp.scrubGroupReportOnly(fileName, documentNumber);
    }

    public void scrubEntries() {
        LOG.debug("scrubEntries() started");

        // The logic for this was moved into another object because the process was written using
        // many instance variables which shouldn't be used for Spring services

        LaborScrubberProcess sp = new LaborScrubberProcess(flexibleOffsetAccountService,
                laborAccountingCycleCachingService, laborOriginEntryService, originEntryGroupService, dateTimeService,
                offsetDefinitionService, objectCodeService, kualiConfigurationService, universityDateDao,
                persistenceService, scrubberValidator, batchFileDirectoryName, laborMainReportWriterService,
                laborLedgerReportWriterService, laborBadBalanceTypeReportWriterService,
                laborErrorListingReportWriterService, laborGeneratedTransactionsReportWriterService,
                laborDemergerReportWriterService, null, null, parameterService, parameterEvaluatorService);
        sp.scrubEntries();
    }

    public void performDemerger() {
        LOG.debug("performDemerger() started");
        LaborScrubberProcess sp = new LaborScrubberProcess(flexibleOffsetAccountService,
                laborAccountingCycleCachingService, laborOriginEntryService, originEntryGroupService, dateTimeService,
                offsetDefinitionService, objectCodeService, kualiConfigurationService, universityDateDao,
                persistenceService, scrubberValidator, batchFileDirectoryName, laborMainReportWriterService,
                laborLedgerReportWriterService, laborBadBalanceTypeReportWriterService,
                laborErrorListingReportWriterService, laborGeneratedTransactionsReportWriterService,
                laborDemergerReportWriterService, null, null, parameterService, parameterEvaluatorService);
        sp.performDemerger();

    }

    public void setScrubberValidator(ScrubberValidator sv) {
        scrubberValidator = sv;
    }

    public void setLaborOriginEntryService(LaborOriginEntryService loes) {
        this.laborOriginEntryService = loes;
    }

    public void setOriginEntryGroupService(OriginEntryGroupService groupService) {
        this.originEntryGroupService = groupService;
    }

    public void setDateTimeService(DateTimeService dts) {
        this.dateTimeService = dts;
    }

    public void setUniversityDateDao(UniversityDateDao universityDateDao) {
        this.universityDateDao = universityDateDao;
    }

    public void setPersistenceService(PersistenceService ps) {
        persistenceService = ps;
    }

    public void setOffsetDefinitionService(OffsetDefinitionService offsetDefinitionService) {
        this.offsetDefinitionService = offsetDefinitionService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }

    public void setFlexibleOffsetAccountService(FlexibleOffsetAccountService flexibleOffsetAccountService) {
        this.flexibleOffsetAccountService = flexibleOffsetAccountService;
    }

    public void setLaborAccountingCycleCachingService(
            LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
    }

    public void setLaborMainReportWriterService(DocumentNumberAwareReportWriterService laborMainReportWriterService) {
        this.laborMainReportWriterService = laborMainReportWriterService;
    }

    public void setLaborLedgerReportWriterService(
            DocumentNumberAwareReportWriterService laborLedgerReportWriterService) {
        this.laborLedgerReportWriterService = laborLedgerReportWriterService;
    }

    public void setLaborBadBalanceTypeReportWriterService(ReportWriterService laborBadBalanceTypeReportWriterService) {
        this.laborBadBalanceTypeReportWriterService = laborBadBalanceTypeReportWriterService;
    }

    public void setLaborErrorListingReportWriterService(ReportWriterService laborErrorListingReportWriterService) {
        this.laborErrorListingReportWriterService = laborErrorListingReportWriterService;
    }

    public void setLaborGeneratedTransactionsReportWriterService(
            DocumentNumberAwareReportWriterService laborGeneratedTransactionsReportWriterService) {
        this.laborGeneratedTransactionsReportWriterService = laborGeneratedTransactionsReportWriterService;
    }

    public void setLaborDemergerReportWriterService(ReportWriterService laborDemergerReportWriterService) {
        this.laborDemergerReportWriterService = laborDemergerReportWriterService;
    }

    public void setLlcpMainReportWriterService(DocumentNumberAwareReportWriterService llcpMainReportWriterService) {
        this.llcpMainReportWriterService = llcpMainReportWriterService;
    }

    public void setLlcpLedgerReportWriterService(DocumentNumberAwareReportWriterService llcpLedgerReportWriterService) {
        this.llcpLedgerReportWriterService = llcpLedgerReportWriterService;
    }

    public void setPreScrubberService(PreScrubberService preScrubberService) {
        this.preScrubberService = preScrubberService;
    }

    public void setLlcpPreScrubberReportWriterService(
            DocumentNumberAwareReportWriterService llcpPreScrubberReportWriterService) {
        this.llcpPreScrubberReportWriterService = llcpPreScrubberReportWriterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }
}
