/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2019 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.integration.ld.LaborLedgerBenefitsType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

/**
 * Labor business object for Benefits Type
 */
public class BenefitsType extends PersistableBusinessObjectBase implements LaborLedgerBenefitsType,
        MutableInactivatable {

    private String positionBenefitTypeCode;
    private String positionBenefitTypeDescription;
    private boolean positionBenefitRetirementIndicator;
    private boolean active;

    public BenefitsType() {

    }

    public String getPositionBenefitTypeCode() {
        return positionBenefitTypeCode;
    }

    public void setPositionBenefitTypeCode(String positionBenefitTypeCode) {
        this.positionBenefitTypeCode = positionBenefitTypeCode;
    }

    public String getPositionBenefitTypeDescription() {
        return positionBenefitTypeDescription;
    }

    public void setPositionBenefitTypeDescription(String positionBenefitTypeDescription) {
        this.positionBenefitTypeDescription = positionBenefitTypeDescription;
    }

    public boolean isPositionBenefitRetirementIndicator() {
        return positionBenefitRetirementIndicator;
    }

    public void setPositionBenefitRetirementIndicator(boolean positionBenefitRetirementIndicator) {
        this.positionBenefitRetirementIndicator = positionBenefitRetirementIndicator;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

}
