/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.sys.batch.AbstractStep;

public class LaborPurgeBalanceStep
extends AbstractStep {
    private static final Logger LOG = LogManager.getLogger(LaborPurgeBalanceStep.class);
    private ChartService chartService;
    private LaborLedgerBalanceService laborLedgerBalanceService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        String fiscalYearAsString = this.getParameterService().getParameterValueAsString(((Object)((Object)this)).getClass(), "PRIOR_TO_YEAR");
        LOG.info("Purge labor balances posted before the year: " + fiscalYearAsString);
        Integer fiscalYear = Integer.parseInt(StringUtils.trim((String)fiscalYearAsString));
        List allChartOfAccountsCode = this.chartService.getAllChartCodes();
        for (String chartOfAccountsCode : allChartOfAccountsCode) {
            this.laborLedgerBalanceService.deleteLedgerBalancesPriorToYear(fiscalYear, chartOfAccountsCode);
        }
        return true;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }
}

