/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.gl.batch.service.PostTransaction;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborGeneralLedgerEntry;
import org.kuali.kfs.module.ld.service.LaborGeneralLedgerEntryService;
import org.kuali.kfs.module.ld.util.DebitCreditUtil;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborGLLedgerEntryPoster
implements PostTransaction {
    private LaborGeneralLedgerEntryService laborGeneralLedgerEntryService;
    private LaborAccountingCycleCachingService laborAccountingCycleCachingService;

    public String post(Transaction transaction, int mode, Date postDate, ReportWriterService posterReportWriterService) {
        String operationType = "insert";
        LaborGeneralLedgerEntry laborGeneralLedgerEntry = new LaborGeneralLedgerEntry();
        ObjectUtil.buildObject((Object)((Object)laborGeneralLedgerEntry), (Object)transaction);
        laborGeneralLedgerEntry.setTransactionDate(new java.sql.Date(postDate.getTime()));
        BalanceType balanceType = this.getBalanceType(transaction.getFinancialBalanceTypeCode());
        if (balanceType.isFinancialOffsetGenerationIndicator()) {
            laborGeneralLedgerEntry.setTransactionDebitCreditCode(this.getDebitCreditCode(transaction));
        } else {
            laborGeneralLedgerEntry.setTransactionDebitCreditCode(" ");
        }
        laborGeneralLedgerEntry.setTransactionLedgerEntryAmount(this.getTransactionAmount(transaction));
        String encumbranceUpdateCode = this.getEncumbranceUpdateCode(transaction);
        if (StringUtils.isNotEmpty((CharSequence)encumbranceUpdateCode)) {
            laborGeneralLedgerEntry.setTransactionEncumbranceUpdateCode(encumbranceUpdateCode);
        }
        Integer sequenceNumber = this.laborGeneralLedgerEntryService.getMaxSequenceNumber(laborGeneralLedgerEntry) + 1;
        laborGeneralLedgerEntry.setTransactionLedgerEntrySequenceNumber(sequenceNumber);
        try {
            this.laborGeneralLedgerEntryService.save(laborGeneralLedgerEntry);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return operationType;
    }

    protected BalanceType getBalanceType(String balanceTypeCode) {
        return this.laborAccountingCycleCachingService.getBalanceType(balanceTypeCode);
    }

    public void setLaborAccountingCycleCachingService(LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
    }

    protected String getDebitCreditCode(Transaction transaction) {
        KualiDecimal transactionAmount = transaction.getTransactionLedgerEntryAmount();
        return DebitCreditUtil.getDebitCreditCode(transactionAmount, false);
    }

    protected KualiDecimal getTransactionAmount(Transaction transaction) {
        KualiDecimal transactionAmount = transaction.getTransactionLedgerEntryAmount();
        return (KualiDecimal)transactionAmount.abs();
    }

    protected String getEncumbranceUpdateCode(Transaction transaction) {
        String encumbranceUpdateCode = transaction.getTransactionEncumbranceUpdateCode();
        if ("D".equals(encumbranceUpdateCode) || "R".equals(encumbranceUpdateCode)) {
            return encumbranceUpdateCode;
        }
        return null;
    }

    public String getDestinationName() {
        return "LD_LBR_GL_ENTRY_T";
    }

    public void setLaborGeneralLedgerEntryService(LaborGeneralLedgerEntryService laborGeneralLedgerEntryService) {
        this.laborGeneralLedgerEntryService = laborGeneralLedgerEntryService;
    }
}

