/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.service.PostTransaction;
import org.kuali.kfs.gl.batch.service.VerifyTransaction;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.gl.report.LedgerSummaryReport;
import org.kuali.kfs.gl.report.TransactionListingReport;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.LaborPosterStep;
import org.kuali.kfs.module.ld.batch.service.LaborPosterService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.document.validation.impl.TransactionFieldValidator;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.service.LaborTransactionDescriptionService;
import org.kuali.kfs.module.ld.util.LaborLedgerUnitOfWork;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborPosterServiceImpl
implements LaborPosterService {
    private static final Logger LOG = LogManager.getLogger(LaborPosterServiceImpl.class);
    protected LaborOriginEntryService laborOriginEntryService;
    protected OriginEntryGroupService originEntryGroupService;
    protected LaborTransactionDescriptionService laborTransactionDescriptionService;
    protected ReportWriterService reportWriterService;
    protected ReportWriterService errorListingReportWriterService;
    protected ReportWriterService ledgerSummaryReportWriterService;
    protected ReportWriterService laborGlEntryStatisticsReportWriterService;
    protected DateTimeService dateTimeService;
    protected VerifyTransaction laborPosterTransactionValidator;
    protected ParameterService parameterService;
    protected PostTransaction laborLedgerEntryPoster;
    protected PostTransaction laborLedgerBalancePoster;
    protected PostTransaction laborGLLedgerEntryPoster;
    protected int numberOfErrorOriginEntry;
    protected String batchFileDirectoryName;
    protected PrintStream POSTER_OUTPUT_ERR_FILE_ps;

    @Override
    public void postMainEntries() {
        LOG.debug("postMainEntries() started");
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        this.postLaborLedgerEntries(runDate);
    }

    protected void postLaborLedgerEntries(Date runDate) {
        FileReader INPUT_GLE_FILE;
        LOG.debug("postLaborLedgerEntries() started..........................");
        this.numberOfErrorOriginEntry = 0;
        String postInputFileName = this.batchFileDirectoryName + File.separator + "ld_sortpost.data";
        String postErrFileName = this.batchFileDirectoryName + File.separator + "ld_posterrs.data";
        try {
            INPUT_GLE_FILE = new FileReader(postInputFileName, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.POSTER_OUTPUT_ERR_FILE_ps = new PrintStream(postErrFileName);
        }
        catch (IOException e) {
            LOG.error("postLaborLedgerEntries cannot open file: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        int lineNumber = 0;
        int loadedCount = 0;
        LaborLedgerUnitOfWork laborLedgerUnitOfWork = new LaborLedgerUnitOfWork();
        LedgerSummaryReport ledgerSummaryReport = new LedgerSummaryReport();
        Map<String, Integer> reportSummary = this.constructPosterReportSummary();
        Map<String, Integer> glEntryReportSummary = this.constructGlEntryReportSummary();
        try {
            BufferedReader INPUT_GLE_FILE_br = new BufferedReader(INPUT_GLE_FILE);
            String currentLine = INPUT_GLE_FILE_br.readLine();
            while (currentLine != null) {
                LaborOriginEntry laborOriginEntry = null;
                try {
                    ++lineNumber;
                    if (!StringUtils.isEmpty((CharSequence)currentLine) && !StringUtils.isBlank((CharSequence)currentLine.trim())) {
                        boolean isPostable;
                        laborOriginEntry = new LaborOriginEntry();
                        List<Message> parsingError = laborOriginEntry.setFromTextFileForBatch(currentLine, lineNumber);
                        if (parsingError.size() > 0) {
                            throw new RuntimeException("Exception happened from parsing process");
                        }
                        if (++loadedCount % 1000 == 0) {
                            LOG.info(loadedCount + " " + laborOriginEntry.toString());
                        }
                        if (isPostable = this.postSingleEntryIntoLaborLedger(laborOriginEntry, reportSummary, runDate, currentLine)) {
                            this.updateReportSummary(glEntryReportSummary, "LD_LBR_ORIGIN_ENTRY_T", "read");
                            this.writeLaborGLEntry(laborOriginEntry, laborLedgerUnitOfWork, runDate, lineNumber, glEntryReportSummary);
                            ledgerSummaryReport.summarizeEntry((OriginEntryInformation)laborOriginEntry);
                            laborOriginEntry = null;
                        }
                    }
                    currentLine = INPUT_GLE_FILE_br.readLine();
                }
                catch (RuntimeException re) {
                    LOG.error("postLaborLedgerEntries stopped due to: " + re.getMessage() + " on line number : " + loadedCount, (Throwable)re);
                    LOG.error("laborOriginEntry failure occurred on: " + laborOriginEntry == null ? null : laborOriginEntry.toString());
                    throw new RuntimeException("Unable to execute: " + re.getMessage() + " on line number : " + loadedCount, re);
                }
            }
            this.writeLaborGLEntry(null, laborLedgerUnitOfWork, runDate, lineNumber, glEntryReportSummary);
            INPUT_GLE_FILE_br.close();
            INPUT_GLE_FILE.close();
            this.POSTER_OUTPUT_ERR_FILE_ps.close();
            this.fillPosterReportWriter(lineNumber, reportSummary, glEntryReportSummary);
            this.fillGlEntryReportWriter(glEntryReportSummary);
            ledgerSummaryReport.writeReport(this.ledgerSummaryReportWriterService);
            new TransactionListingReport().generateReport(this.errorListingReportWriterService, (Iterator)new LaborOriginEntryFileIterator(new File(postErrFileName)));
        }
        catch (IOException ioe) {
            LOG.error("postLaborLedgerEntries stopped due to: " + ioe.getMessage(), (Throwable)ioe);
            throw new RuntimeException("Unable to execute: " + ioe.getMessage() + " on line number : " + loadedCount, ioe);
        }
    }

    protected boolean postSingleEntryIntoLaborLedger(LaborOriginEntry originEntry, Map<String, Integer> reportSummary, Date runDate, String line) {
        List<Object> errors = new ArrayList<Message>();
        try {
            errors = this.validateEntry(originEntry);
        }
        catch (Exception e) {
            errors.add(new Message(e.toString() + " occurred for this record.", 1));
        }
        if (errors != null && !errors.isEmpty()) {
            this.reportWriterService.writeError((BusinessObject)originEntry, errors);
            this.numberOfErrorOriginEntry += errors.size();
            this.writeErrorEntry(line);
            return false;
        }
        String operationOnLedgerEntry = this.postAsLedgerEntry(originEntry, runDate);
        this.updateReportSummary(reportSummary, this.laborLedgerEntryPoster.getDestinationName(), operationOnLedgerEntry);
        String operationOnLedgerBalance = this.updateLedgerBalance(originEntry, runDate);
        this.updateReportSummary(reportSummary, this.laborLedgerBalancePoster.getDestinationName(), operationOnLedgerBalance);
        return true;
    }

    protected List<Message> validateEntry(LaborOriginEntry originEntry) {
        return this.laborPosterTransactionValidator.verifyTransaction((Transaction)originEntry);
    }

    protected String postAsLedgerEntry(LaborOriginEntry originEntry, Date postDate) {
        return this.laborLedgerEntryPoster.post((Transaction)originEntry, 0, (java.util.Date)postDate, null);
    }

    protected String updateLedgerBalance(LaborOriginEntry originEntry, Date postDate) {
        return this.laborLedgerBalancePoster.post((Transaction)originEntry, 0, (java.util.Date)postDate, null);
    }

    protected List<Message> isPostableForLaborGLEntry(LaborOriginEntry originEntry) {
        ArrayList<Message> errors = new ArrayList<Message>();
        MessageBuilder.addMessageIntoList(errors, (Message)TransactionFieldValidator.checkPostablePeridCode(originEntry, this.getPeriodCodesNotProcessed()));
        MessageBuilder.addMessageIntoList(errors, (Message)TransactionFieldValidator.checkPostableBalanceTypeCode(originEntry, this.getBalanceTypesNotProcessed()));
        MessageBuilder.addMessageIntoList(errors, (Message)TransactionFieldValidator.checkZeroTotalAmount(originEntry));
        return errors;
    }

    protected void fillPosterReportWriter(int lineNumber, Map<String, Integer> reportSummary, Map<String, Integer> glEntryReportSummary) {
        this.reportWriterService.writeStatisticLine("SEQUENTIAL RECORDS READ                    %,9d", new Object[]{lineNumber});
        this.reportWriterService.writeStatisticLine("LLEN RECORDS INSERTED (LD_LDGR_ENTR_T)     %,9d", new Object[]{reportSummary.get(this.laborLedgerEntryPoster.getDestinationName() + ",insert")});
        this.reportWriterService.writeStatisticLine("LLBL RECORDS INSERTED (LD_LDGR_BAL_T)      %,9d", new Object[]{reportSummary.get(this.laborLedgerBalancePoster.getDestinationName() + ",insert")});
        this.reportWriterService.writeStatisticLine("LLBL RECORDS UPDATED  (LD_LDGR_BAL_T)      %,9d", new Object[]{reportSummary.get(this.laborLedgerBalancePoster.getDestinationName() + ",update")});
        this.reportWriterService.writeStatisticLine("LLGL RECORDS INSERTED (LD_LBR_GL_ENTRY_T)  %,9d", new Object[]{glEntryReportSummary.get(this.laborGLLedgerEntryPoster.getDestinationName() + ",insert")});
        this.reportWriterService.writeStatisticLine("WARNING RECORDS WRITTEN                    %,9d", new Object[]{this.numberOfErrorOriginEntry});
    }

    protected Map<String, Integer> constructPosterReportSummary() {
        HashMap<String, Integer> reportSummary = new HashMap<String, Integer>();
        reportSummary.put(this.laborLedgerEntryPoster.getDestinationName() + ",insert", 0);
        reportSummary.put(this.laborLedgerBalancePoster.getDestinationName() + ",insert", 0);
        reportSummary.put(this.laborLedgerBalancePoster.getDestinationName() + ",update", 0);
        reportSummary.put(this.laborGLLedgerEntryPoster.getDestinationName() + ",insert", 0);
        return reportSummary;
    }

    protected Map<String, Integer> constructGlEntryReportSummary() {
        HashMap<String, Integer> glEntryReportSummary = new HashMap<String, Integer>();
        glEntryReportSummary.put("LD_LBR_ORIGIN_ENTRY_T,read", 0);
        glEntryReportSummary.put("LD_LBR_ORIGIN_ENTRY_T,bypassed", 0);
        glEntryReportSummary.put("LD_LBR_ORIGIN_ENTRY_T,select", 0);
        glEntryReportSummary.put("LD_LBR_ORIGIN_ENTRY_T,with error", 0);
        glEntryReportSummary.put(this.laborGLLedgerEntryPoster.getDestinationName() + ",insert", 0);
        return glEntryReportSummary;
    }

    protected void fillGlEntryReportWriter(Map<String, Integer> glEntryReportSummary) {
        this.laborGlEntryStatisticsReportWriterService.writeStatisticLine("NUMBER OF RECORDS READ              %,9d", new Object[]{glEntryReportSummary.get("LD_LBR_ORIGIN_ENTRY_T,read")});
        this.laborGlEntryStatisticsReportWriterService.writeStatisticLine("NUMBER OF RECORDS BYPASSED          %,9d", new Object[]{glEntryReportSummary.get("LD_LBR_ORIGIN_ENTRY_T,bypassed")});
        this.laborGlEntryStatisticsReportWriterService.writeStatisticLine("NUMBER OF RECORDS SELECTED          %,9d", new Object[]{glEntryReportSummary.get("LD_LBR_ORIGIN_ENTRY_T,select")});
        this.laborGlEntryStatisticsReportWriterService.writeStatisticLine("NUMBER OF RECORDS IN ERROR          %,9d", new Object[]{glEntryReportSummary.get("LD_LBR_ORIGIN_ENTRY_T,with error")});
        this.laborGlEntryStatisticsReportWriterService.writeStatisticLine("NUMBER OF RECORDS INSERTED          %,9d", new Object[]{glEntryReportSummary.get(this.laborGLLedgerEntryPoster.getDestinationName() + ",insert")});
    }

    protected LaborOriginEntry summarizeLaborGLEntries(LaborOriginEntry laborOriginEntry, LaborLedgerUnitOfWork laborLedgerUnitOfWork, Date runDate, int lineNumber, Map<String, Integer> glEntryReportSummary) {
        String description;
        if (ObjectUtils.isNotNull((Object)laborOriginEntry) && StringUtils.isNotEmpty((CharSequence)(description = this.laborTransactionDescriptionService.getTransactionDescription(laborOriginEntry)))) {
            laborOriginEntry.setTransactionLedgerEntryDescription(description);
        }
        LaborOriginEntry summarizedEntry = null;
        if (laborLedgerUnitOfWork.canContain(laborOriginEntry)) {
            laborLedgerUnitOfWork.addEntryIntoUnit(laborOriginEntry);
            this.updateReportSummary(glEntryReportSummary, "LD_LBR_ORIGIN_ENTRY_T", "select");
        } else {
            summarizedEntry = laborLedgerUnitOfWork.getWorkingEntry();
            laborLedgerUnitOfWork.resetLaborLedgerUnitOfWork(laborOriginEntry);
        }
        return summarizedEntry;
    }

    protected void writeLaborGLEntry(LaborOriginEntry laborOriginEntry, LaborLedgerUnitOfWork laborLedgerUnitOfWork, Date runDate, int lineNumber, Map<String, Integer> glEntryReportSummary) {
        LaborOriginEntry summarizedEntry = this.summarizeLaborGLEntries(laborOriginEntry, laborLedgerUnitOfWork, runDate, lineNumber, glEntryReportSummary);
        if (summarizedEntry == null) {
            return;
        }
        try {
            List<Message> errors = this.isPostableForLaborGLEntry(summarizedEntry);
            if (errors == null || errors.isEmpty()) {
                String operationType = this.laborGLLedgerEntryPoster.post((Transaction)summarizedEntry, 0, (java.util.Date)runDate, null);
                this.updateReportSummary(glEntryReportSummary, this.laborGLLedgerEntryPoster.getDestinationName(), operationType);
            } else {
                this.updateReportSummary(glEntryReportSummary, "LD_LBR_ORIGIN_ENTRY_T", "bypassed");
            }
        }
        catch (RuntimeException ioe) {
            LOG.error("postLaborGLEntries stopped due to: " + ioe.getMessage() + " on line number : " + lineNumber, (Throwable)ioe);
            throw new RuntimeException("Unable to execute: " + ioe.getMessage() + " on line number : " + lineNumber, ioe);
        }
    }

    protected void updateReportSummary(Map<String, Integer> reportSummary, String destination, String operation) {
        String key = destination + "," + operation;
        if (reportSummary.containsKey(key)) {
            Integer count = reportSummary.get(key);
            reportSummary.put(key, count + 1);
        } else {
            reportSummary.put(key, 1);
        }
    }

    protected void writeErrorEntry(String line) {
        try {
            this.POSTER_OUTPUT_ERR_FILE_ps.printf("%s\n", line);
        }
        catch (Exception e) {
            LOG.error("postAsProcessedOriginEntry stopped due to: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to execute: " + e.getMessage(), e);
        }
    }

    public Collection<String> getBalanceTypesNotProcessed() {
        return this.parameterService.getParameterValuesAsString(LaborPosterStep.class, "SENT_TO_GL_BALANCE_TYPES");
    }

    public Collection<String> getPeriodCodesNotProcessed() {
        return this.parameterService.getParameterValuesAsString(LaborPosterStep.class, "SENT_TO_GL_PERIOD_CODES");
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setLaborLedgerBalancePoster(PostTransaction laborLedgerBalancePoster) {
        this.laborLedgerBalancePoster = laborLedgerBalancePoster;
    }

    public void setLaborGLLedgerEntryPoster(PostTransaction laborGLLedgerEntryPoster) {
        this.laborGLLedgerEntryPoster = laborGLLedgerEntryPoster;
    }

    public void setLaborLedgerEntryPoster(PostTransaction laborLedgerEntryPoster) {
        this.laborLedgerEntryPoster = laborLedgerEntryPoster;
    }

    public void setLaborOriginEntryService(LaborOriginEntryService laborOriginEntryService) {
        this.laborOriginEntryService = laborOriginEntryService;
    }

    public void setOriginEntryGroupService(OriginEntryGroupService originEntryGroupService) {
        this.originEntryGroupService = originEntryGroupService;
    }

    public void setLaborTransactionDescriptionService(LaborTransactionDescriptionService laborTransactionDescriptionService) {
        this.laborTransactionDescriptionService = laborTransactionDescriptionService;
    }

    public void setReportWriterService(ReportWriterService reportWriterService) {
        this.reportWriterService = reportWriterService;
    }

    public void setErrorListingReportWriterService(ReportWriterService errorListingReportWriterService) {
        this.errorListingReportWriterService = errorListingReportWriterService;
    }

    public void setLedgerSummaryReportWriterService(ReportWriterService ledgerSummaryReportWriterService) {
        this.ledgerSummaryReportWriterService = ledgerSummaryReportWriterService;
    }

    public void setLaborPosterTransactionValidator(VerifyTransaction laborPosterTransactionValidator) {
        this.laborPosterTransactionValidator = laborPosterTransactionValidator;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setLaborGlEntryStatisticsReportWriterService(ReportWriterService laborGlEntryStatisticsReportWriterService) {
        this.laborGlEntryStatisticsReportWriterService = laborGlEntryStatisticsReportWriterService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

