/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.lookup.LedgerBalanceForExpenseTransferLookupableHelperServiceImpl;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.krad.bo.BusinessObject;

public class LedgerBalanceForBenefitExpenseTransferLookupableHelperServiceImpl
extends LedgerBalanceForExpenseTransferLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    private static final String CHART_OF_ACCOUNTS_CODE = "chartOfAccountsCode";
    private AccountService accountService;
    private OptionsService optionsService;

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LOG.debug("Start getSearchResults()");
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String fiscalYearString = fieldValues.get("universityFiscalYear");
        SystemOptions options = this.getOptions(fiscalYearString);
        if (ObjectUtils.isNull((Object)options)) {
            return new CollectionIncomplete(new ArrayList(), Long.valueOf(0L));
        }
        fieldValues.put("financialObjectTypeCode", options.getFinObjTypeExpenditureexpCd());
        fieldValues.put("laborObject.financialObjectFringeOrSalaryCode", "F");
        fieldValues.put("financialBalanceTypeCode", options.getActualFinancialBalanceTypeCd());
        Collection actualBalances = this.buildDetailedBalanceCollection(this.balanceService.findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), false), "No");
        fieldValues.put("financialBalanceTypeCode", "A2");
        Collection effortBalances = this.buildDetailedBalanceCollection(this.balanceService.findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), false), "No");
        List<String> consolidationKeyList = this.getConsolidationKeyList();
        Collection<LedgerBalance> consolidatedBalances = ConsolidationUtil.consolidateA2Balances(actualBalances, effortBalances, options.getActualFinancialBalanceTypeCd(), consolidationKeyList);
        this.resetFieldValues(consolidatedBalances);
        Integer recordCount = this.balanceService.getBalanceRecordCount(fieldValues, true, this.getEncumbranceBalanceTypes(fieldValues), false);
        Long actualSize = OJBUtility.getResultActualSize(consolidatedBalances, (Integer)recordCount, fieldValues, (Object)((Object)new LedgerBalance()));
        return this.buildSearchResultList(consolidatedBalances, actualSize);
    }

    private void resetFieldValues(Collection<LedgerBalance> consolidatedBalances) {
        for (LedgerBalance ledgerBalance : consolidatedBalances) {
            ledgerBalance.setEmplid(null);
            ledgerBalance.setPositionNumber(null);
        }
    }

    private List<String> getConsolidationKeyList() {
        ArrayList<String> consolidationKeyList = new ArrayList<String>();
        consolidationKeyList.add("universityFiscalYear");
        consolidationKeyList.add(CHART_OF_ACCOUNTS_CODE);
        consolidationKeyList.add("accountNumber");
        consolidationKeyList.add("subAccountNumber");
        consolidationKeyList.add("financialObjectCode");
        consolidationKeyList.add("financialSubObjectCode");
        consolidationKeyList.add("financialBalanceTypeCode");
        consolidationKeyList.add("financialObjectTypeCode");
        return consolidationKeyList;
    }

    private SystemOptions getOptions(String fiscalYearString) {
        SystemOptions options;
        if (fiscalYearString == null) {
            options = this.optionsService.getCurrentYearOptions();
        } else {
            Integer fiscalYear = Integer.valueOf(fiscalYearString.trim());
            options = this.optionsService.getOptions(fiscalYear);
        }
        return options;
    }

    public List<String> getReadOnlyFieldsList() {
        ArrayList<String> readonlyList = super.getReadOnlyFieldsList();
        if (readonlyList == null) {
            readonlyList = new ArrayList<String>();
        }
        if (!this.accountService.accountsCanCrossCharts()) {
            readonlyList.add(CHART_OF_ACCOUNTS_CODE);
        }
        return readonlyList;
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        if (!this.accountService.accountsCanCrossCharts()) {
            fieldValues.remove(CHART_OF_ACCOUNTS_CODE);
        }
        super.validateSearchParameters(fieldValues);
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

