/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Set;
import org.kuali.kfs.kns.rules.PromptBeforeValidationBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.SalaryExpenseTransferTransactionAgeService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class SalaryExpenseTransferDocumentPreRules
extends PromptBeforeValidationBase {
    protected static SalaryExpenseTransferTransactionAgeService salaryTransferTransactionAgeService;

    public boolean doPrompts(Document document) {
        SalaryExpenseTransferDocument stDocument = (SalaryExpenseTransferDocument)document;
        return this.errorCertStmtApproved(stDocument);
    }

    protected boolean errorCertStmtApproved(SalaryExpenseTransferDocument stDocument) {
        boolean fiscalOfficerNode = this.checkRouteLevel(stDocument);
        boolean parameterTriggered = this.checkTargetLines(stDocument);
        if (fiscalOfficerNode && parameterTriggered) {
            return this.showErrorCertStmt();
        }
        return true;
    }

    protected boolean checkRouteLevel(SalaryExpenseTransferDocument stDocument) {
        WorkflowDocument workflowDocument = stDocument.getDocumentHeader().getWorkflowDocument();
        Set currentActiveNodes = workflowDocument.getCurrentNodeNames();
        return currentActiveNodes.contains("Account");
    }

    protected boolean checkTargetLines(SalaryExpenseTransferDocument stDocument) {
        Integer initialPeriodsFromParameter = null;
        return !this.getSalaryExpenseTransferTransactionAgeService().defaultNumberOfFiscalPeriodsCheck(stDocument.getTargetAccountingLines(), initialPeriodsFromParameter);
    }

    protected boolean showErrorCertStmt() {
        String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("question.lateAdjustStmt");
        boolean approved = super.askOrAnalyzeYesNoQuestion("GenerateLateAdjustStmt", questionText);
        if (!approved) {
            this.event.setActionForwardName("basic");
        }
        return approved;
    }

    public SalaryExpenseTransferTransactionAgeService getSalaryExpenseTransferTransactionAgeService() {
        if (ObjectUtils.isNull((Object)salaryTransferTransactionAgeService)) {
            salaryTransferTransactionAgeService = (SalaryExpenseTransferTransactionAgeService)SpringContext.getBean(SalaryExpenseTransferTransactionAgeService.class);
        }
        return salaryTransferTransactionAgeService;
    }

    public void setSalaryExpenseTransferTransactionAgeService(SalaryExpenseTransferTransactionAgeService salaryTransferTransactionAgeService) {
        SalaryExpenseTransferDocumentPreRules.salaryTransferTransactionAgeService = salaryTransferTransactionAgeService;
    }
}

