/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class SalaryExpenseTransferDuplicateAccountingLineValidation
extends GenericValidation {
    private AccountingDocument accountingDocumentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        if (this.hasDuplicateAccountingLine()) {
            GlobalVariables.getMessageMap().addToErrorPath("document");
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.duplicateAccountingLine", new String[0]);
            GlobalVariables.getMessageMap().removeFromErrorPath("document");
            return false;
        }
        return true;
    }

    private boolean hasDuplicateAccountingLine() {
        AccountingDocument accountingDocument = this.getAccountingDocumentForValidation();
        SalaryExpenseTransferDocument salaryExpenseTransferDocument = (SalaryExpenseTransferDocument)accountingDocument;
        List sourceAccountingLines = salaryExpenseTransferDocument.getSourceAccountingLines();
        List targetAccountingLines = salaryExpenseTransferDocument.getTargetAccountingLines();
        List<String> key = this.defaultKeyOfExpenseTransferAccountingLine();
        return targetAccountingLines.stream().anyMatch(targetAccountingLine -> sourceAccountingLines.stream().anyMatch(sourceAccountingLine -> ObjectUtil.equals((Object)targetAccountingLine, (Object)sourceAccountingLine, (List)key)));
    }

    private List<String> defaultKeyOfExpenseTransferAccountingLine() {
        ArrayList<String> defaultKey = new ArrayList<String>();
        defaultKey.add("chartOfAccountsCode");
        defaultKey.add("accountNumber");
        defaultKey.add("subAccountNumber");
        defaultKey.add("financialObjectCode");
        defaultKey.add("financialSubObjectCode");
        defaultKey.add("projectCode");
        defaultKey.add("organizationReferenceId");
        defaultKey.add("payrollEndDateFiscalYear");
        defaultKey.add("payrollEndDateFiscalPeriodCode");
        defaultKey.add("amount");
        return defaultKey;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }
}

