/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.util.Map;
import org.kuali.kfs.module.ld.businessobject.LaborAccountingLineOverride;
import org.kuali.kfs.module.ld.document.web.struts.LaborDocumentFormBase;
import org.kuali.kfs.module.ld.document.web.struts.MultipleValueLookupBroker;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.OptionsService;

public abstract class ExpenseTransferDocumentFormBase
extends LaborDocumentFormBase
implements MultipleValueLookupBroker {
    protected String lookupResultsSequenceNumber;
    protected String lookupResultsBOClassName;
    protected String lookedUpCollectionName;
    protected Integer universityFiscalYear;

    public ExpenseTransferDocumentFormBase() {
        this.setUniversityFiscalYear(((OptionsService)SpringContext.getBean(OptionsService.class)).getCurrentYearOptions().getUniversityFiscalYear());
    }

    public void addRequiredNonEditableProperties() {
        super.addRequiredNonEditableProperties();
        this.registerRequiredNonEditableProperty("lookupResultsSequenceNumber");
    }

    @Override
    public String getLookupResultsSequenceNumber() {
        return this.lookupResultsSequenceNumber;
    }

    @Override
    public void setLookupResultsSequenceNumber(String lookupResultsSequenceNumber) {
        this.lookupResultsSequenceNumber = lookupResultsSequenceNumber;
    }

    @Override
    public String getLookupResultsBOClassName() {
        return this.lookupResultsBOClassName;
    }

    @Override
    public void setLookupResultsBOClassName(String lookupResultsBOClassName) {
        this.lookupResultsBOClassName = lookupResultsBOClassName;
    }

    @Override
    public String getLookedUpCollectionName() {
        return this.lookedUpCollectionName;
    }

    @Override
    public void setLookedUpCollectionName(String lookedUpCollectionName) {
        this.lookedUpCollectionName = lookedUpCollectionName;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public abstract void populateSearchFields();

    public Map getForcedReadOnlySourceFields() {
        Map map = super.getForcedReadOnlyFields();
        map.put("chartOfAccountsCode", Boolean.TRUE);
        map.put("accountNumber", Boolean.TRUE);
        map.put("subAccountNumber", Boolean.TRUE);
        map.put("financialObjectCode", Boolean.TRUE);
        map.put("financialSubObjectCode", Boolean.TRUE);
        map.put("projectCode", Boolean.TRUE);
        map.put("organizationReferenceId", Boolean.TRUE);
        map.put("positionNumber", Boolean.TRUE);
        map.put("payrollEndDateFiscalPeriodCode", Boolean.TRUE);
        map.put("payrollEndDateFiscalYear", Boolean.TRUE);
        return map;
    }

    public Map getForcedReadOnlyTargetFields() {
        Map map = super.getForcedReadOnlyFields();
        map.put("payrollEndDateFiscalPeriodCode", Boolean.TRUE);
        map.put("payrollEndDateFiscalYear", Boolean.TRUE);
        return map;
    }

    public void populateSourceAccountingLine(SourceAccountingLine sourceLine, String accountingLinePropertyName, Map parameterMap) {
        super.populateSourceAccountingLine(sourceLine, accountingLinePropertyName, parameterMap);
        LaborAccountingLineOverride.populateFromInput((AccountingLine)sourceLine);
    }

    public void populateTargetAccountingLine(TargetAccountingLine targetLine, String accountingLinePropertyName, Map parameterMap) {
        super.populateTargetAccountingLine(targetLine, accountingLinePropertyName, parameterMap);
        LaborAccountingLineOverride.populateFromInput((AccountingLine)targetLine);
    }

    protected void repopulateOverrides(AccountingLine line, String accountingLinePropertyName, Map parameterMap) {
        super.repopulateOverrides(line, accountingLinePropertyName, parameterMap);
        LaborAccountingLineOverride.determineNeededOverrides(this.getFinancialDocument(), line);
        if (line.getNonFringeAccountOverrideNeeded()) {
            if (parameterMap.containsKey(accountingLinePropertyName + ".nonFringeAccountOverride.present")) {
                line.setNonFringeAccountOverride(parameterMap.containsKey(accountingLinePropertyName + ".nonFringeAccountOverride"));
            }
        } else {
            line.setNonFringeAccountOverride(false);
        }
    }
}

