/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.module.ld.businessobject.BenefitInquiry;
import org.kuali.kfs.module.ld.businessobject.PositionObjectBenefit;
import org.kuali.kfs.module.ld.document.web.struts.FringeBenefitInquiryForm;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.service.LaborPositionObjectBenefitService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class FringeBenefitInquiryAction
extends KualiAction {
    public ActionForward calculateFringeBenefit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FringeBenefitInquiryForm accountingLineForm = (FringeBenefitInquiryForm)form;
        Integer payrollFiscalYear = Integer.valueOf(accountingLineForm.getPayrollEndDateFiscalYear());
        String chartOfAccountsCode = accountingLineForm.getChartOfAccountsCode();
        String objectCode = accountingLineForm.getFinancialObjectCode();
        KualiDecimal amount = new KualiDecimal(accountingLineForm.getAmount());
        Collection<PositionObjectBenefit> positionObjectBenefits = ((LaborPositionObjectBenefitService)SpringContext.getBean(LaborPositionObjectBenefitService.class)).getActivePositionObjectBenefits(payrollFiscalYear, chartOfAccountsCode, objectCode);
        ArrayList<BenefitInquiry> fringeBenefitEntries = new ArrayList<BenefitInquiry>();
        for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            if (!positionObjectBenefit.getBenefitsCalculation().isActive()) continue;
            BenefitInquiry benefitInquiry = new BenefitInquiry();
            String fringeBenefitObjectCode = positionObjectBenefit.getBenefitsCalculation().getPositionFringeBenefitObjectCode();
            benefitInquiry.setFringeBenefitObjectCode(fringeBenefitObjectCode);
            KualiDecimal benefitAmount = ((LaborBenefitsCalculationService)SpringContext.getBean(LaborBenefitsCalculationService.class)).calculateFringeBenefit(positionObjectBenefit, amount, accountingLineForm.getAccountNumber(), accountingLineForm.getSubAccountNumber());
            benefitInquiry.setBenefitAmount(benefitAmount);
            fringeBenefitEntries.add(benefitInquiry);
        }
        fringeBenefitEntries.sort(Collections.reverseOrder());
        accountingLineForm.setBenefitInquiry(fringeBenefitEntries);
        return mapping.findForward("basic");
    }
}

