/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.BenefitsCalculation;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.PositionObjectBenefit;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.service.LaborPositionObjectBenefitService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborBenefitsCalculationServiceImpl
implements LaborBenefitsCalculationService {
    private static final Logger LOG = LogManager.getLogger();
    private BusinessObjectService businessObjectService;
    private LaborPositionObjectBenefitService laborPositionObjectBenefitService;
    private AccountService accountService;
    private ParameterService parameterService;
    private String costSharingSourceAccountNumber;
    private String costSharingSourceSubAccountNumber;
    private String costSharingSourceAccountChartOfAccountsCode;

    @Override
    public BenefitsCalculation getBenefitsCalculation(Integer universityFiscalYear, String chartOfAccountsCode, String benefitTypeCode) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", universityFiscalYear);
        fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        fieldValues.put("positionBenefitTypeCode", benefitTypeCode);
        return (BenefitsCalculation)this.businessObjectService.findByPrimaryKey(BenefitsCalculation.class, fieldValues);
    }

    @Override
    public BenefitsCalculation getBenefitsCalculation(Integer universityFiscalYear, String chartOfAccountsCode, String benefitTypeCode, String laborBenefitRateCategoryCode) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", universityFiscalYear);
        fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        fieldValues.put("positionBenefitTypeCode", benefitTypeCode);
        fieldValues.put("laborBenefitRateCategoryCode", laborBenefitRateCategoryCode);
        return (BenefitsCalculation)this.businessObjectService.findByPrimaryKey(BenefitsCalculation.class, fieldValues);
    }

    @Override
    public KualiDecimal calculateFringeBenefit(Integer fiscalYear, String chartCode, String objectCode, KualiDecimal salaryAmount, String accountNumber, String subAccountNumber) {
        LaborObject laborObject = new LaborObject();
        laborObject.setUniversityFiscalYear(fiscalYear);
        laborObject.setChartOfAccountsCode(chartCode);
        laborObject.setFinancialObjectCode(objectCode);
        laborObject = (LaborObject)this.businessObjectService.retrieve((PersistableBusinessObject)laborObject);
        return this.calculateFringeBenefit(laborObject, salaryAmount, accountNumber, subAccountNumber);
    }

    @Override
    public KualiDecimal calculateFringeBenefit(LaborLedgerObject laborLedgerObject, KualiDecimal salaryAmount, String accountNumber, String subAccountNumber) {
        KualiDecimal fringeBenefit = KualiDecimal.ZERO;
        if (salaryAmount == null || salaryAmount.isZero() || ObjectUtils.isNull((Object)laborLedgerObject)) {
            return fringeBenefit;
        }
        String FringeOrSalaryCode = laborLedgerObject.getFinancialObjectFringeOrSalaryCode();
        if (!"S".equals(FringeOrSalaryCode)) {
            return fringeBenefit;
        }
        Integer fiscalYear = laborLedgerObject.getUniversityFiscalYear();
        String chartOfAccountsCode = laborLedgerObject.getChartOfAccountsCode();
        String objectCode = laborLedgerObject.getFinancialObjectCode();
        Collection<PositionObjectBenefit> positionObjectBenefits = this.laborPositionObjectBenefitService.getActivePositionObjectBenefits(fiscalYear, chartOfAccountsCode, objectCode);
        for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            KualiDecimal benefitAmount = this.calculateFringeBenefit(positionObjectBenefit, salaryAmount, accountNumber, subAccountNumber);
            fringeBenefit = (KualiDecimal)fringeBenefit.add((AbstractKualiDecimal)benefitAmount);
        }
        return fringeBenefit;
    }

    @Override
    public KualiDecimal calculateFringeBenefit(PositionObjectBenefit positionObjectBenefit, KualiDecimal salaryAmount, String accountNumber, String subAccountNumber) {
        if (salaryAmount == null || salaryAmount.isZero() || ObjectUtils.isNull((Object)((Object)positionObjectBenefit))) {
            return KualiDecimal.ZERO;
        }
        KualiDecimal fringeBenefitAmount = new KualiDecimal(0);
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", positionObjectBenefit.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", positionObjectBenefit.getChartOfAccountsCode());
        fieldValues.put("positionBenefitTypeCode", positionObjectBenefit.getFinancialObjectBenefitsTypeCode());
        Boolean enableFringeBenefitCalculationByBenefitRate = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
        if (enableFringeBenefitCalculationByBenefitRate.booleanValue()) {
            String laborBenefitRateCategoryCode = this.getBenefitRateCategoryCode(positionObjectBenefit.getChartOfAccountsCode(), accountNumber, subAccountNumber);
            fieldValues.put("laborBenefitRateCategoryCode", laborBenefitRateCategoryCode);
            String search = fieldValues.get("universityFiscalYear") + "," + fieldValues.get("chartOfAccountsCode") + "," + fieldValues.get("positionBenefitTypeCode") + "," + fieldValues.get("laborBenefitRateCategoryCode");
            LOG.info("Searching for Benefits Calculation {" + search + "}");
            BenefitsCalculation bc = (BenefitsCalculation)this.businessObjectService.findByPrimaryKey(BenefitsCalculation.class, fieldValues);
            if (bc != null && bc.isActive()) {
                LOG.info("Found a Benefit Calculation for {" + search + "}");
                KualiPercent fringeBenefitPercent = bc.getPositionFringeBenefitPercent();
                LOG.debug("fringeBenefitPercent: " + (KualiDecimal)fringeBenefitPercent);
                fringeBenefitAmount = (KualiDecimal)((KualiDecimal)fringeBenefitPercent.multiply((AbstractKualiDecimal)salaryAmount)).divide((AbstractKualiDecimal)KFSConstants.ONE_HUNDRED.kualiDecimalValue());
            } else {
                LOG.info("Did not locate a Benefits Calculation for {" + search + "}.");
                fringeBenefitAmount = new KualiDecimal(0);
            }
        } else if (positionObjectBenefit.getBenefitsCalculation().isActive()) {
            KualiPercent fringeBenefitPercent = positionObjectBenefit.getBenefitsCalculation().getPositionFringeBenefitPercent();
            fringeBenefitAmount = (KualiDecimal)((KualiDecimal)fringeBenefitPercent.multiply((AbstractKualiDecimal)salaryAmount)).divide((AbstractKualiDecimal)KFSConstants.ONE_HUNDRED.kualiDecimalValue());
        }
        LOG.debug("fringeBenefitAmount: " + fringeBenefitAmount);
        return fringeBenefitAmount;
    }

    @Override
    public String getBenefitRateCategoryCode(String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        this.setCostSharingSourceAccountNumber(null);
        this.setCostSharingSourceAccountChartOfAccountsCode(null);
        this.setCostSharingSourceSubAccountNumber(null);
        if (subAccountNumber != null) {
            LOG.info("Sub Account Number was filled in. Checking to see if it is a Cost Sharing Sub Account.");
            if (this.parameterService.parameterExists(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "USE_COST_SHARE_SOURCE_ACCOUNT_BENEFIT_RATE_IND").booleanValue()) {
                String sysParam2 = this.parameterService.getParameterValueAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "USE_COST_SHARE_SOURCE_ACCOUNT_BENEFIT_RATE_IND");
                LOG.debug("sysParam2: " + sysParam2);
                if ("Y".equalsIgnoreCase(sysParam2)) {
                    HashMap<String, String> subFieldValues = new HashMap<String, String>();
                    subFieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
                    subFieldValues.put("subAccountNumber", subAccountNumber);
                    subFieldValues.put("subAccountTypeCode", "CS");
                    LOG.info("Looking for a cost sharing sub account for sub account number " + subAccountNumber);
                    List subAccountList = (List)this.businessObjectService.findMatching(A21SubAccount.class, subFieldValues);
                    if (subAccountList.size() > 0) {
                        LOG.info("Found A21 Sub Account. Retrieving source account number for cost sharing.");
                        accountNumber = ((A21SubAccount)subAccountList.get(0)).getCostShareSourceAccountNumber();
                        LOG.debug("Cost Sharing Source Account Number : " + accountNumber);
                        this.setCostSharingSourceAccountNumber(accountNumber);
                        this.setCostSharingSourceAccountChartOfAccountsCode(((A21SubAccount)subAccountList.get(0)).getCostShareChartOfAccountCode());
                        this.setCostSharingSourceSubAccountNumber(((A21SubAccount)subAccountList.get(0)).getCostShareSourceSubAccountNumber());
                    } else {
                        LOG.info(subAccountNumber + " is not a cost sharing account.  Using the Labor Benefit Rate Category from the account number.");
                    }
                } else {
                    LOG.info("Using the Grant Account to determine the labor benefit rate category code.");
                }
            }
        }
        LOG.info("Looking up Account {" + chartOfAccountsCode + "," + accountNumber + "}");
        Account account = this.accountService.getByPrimaryId(chartOfAccountsCode, accountNumber);
        String laborBenefitRateCategoryCode = null;
        if (account == null) {
            LOG.info("The Account {" + chartOfAccountsCode + "," + accountNumber + "} could not be found.");
        } else {
            laborBenefitRateCategoryCode = account.getLaborBenefitRateCategoryCode();
        }
        if (StringUtils.isBlank((CharSequence)laborBenefitRateCategoryCode)) {
            LOG.info("The Account did not have a Labor Benefit Rate Category Code. Will use the system parameter default.");
            laborBenefitRateCategoryCode = StringUtils.defaultString((String)this.parameterService.getParameterValueAsString(Account.class, "DEFAULT_BENEFIT_RATE_CATEGORY_CODE"));
        } else {
            LOG.debug("Labor Benefit Rate Category Code for Account " + accountNumber + " is " + laborBenefitRateCategoryCode);
        }
        return laborBenefitRateCategoryCode;
    }

    public void setLaborPositionObjectBenefitService(LaborPositionObjectBenefitService laborPositionObjectBenefitService) {
        this.laborPositionObjectBenefitService = laborPositionObjectBenefitService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    protected AccountService getAccountService() {
        return this.accountService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public String getCostSharingSourceAccountNumber() {
        return this.costSharingSourceAccountNumber;
    }

    public void setCostSharingSourceAccountNumber(String costSharingSourceAccountNumber) {
        this.costSharingSourceAccountNumber = costSharingSourceAccountNumber;
    }

    @Override
    public String getCostSharingSourceSubAccountNumber() {
        return this.costSharingSourceSubAccountNumber;
    }

    public void setCostSharingSourceSubAccountNumber(String costSharingSourceSubAccountNumber) {
        this.costSharingSourceSubAccountNumber = costSharingSourceSubAccountNumber;
    }

    @Override
    public String getCostSharingSourceAccountChartOfAccountsCode() {
        return this.costSharingSourceAccountChartOfAccountsCode;
    }

    public void setCostSharingSourceAccountChartOfAccountsCode(String costSharingSourceAccountChartOfAccountsCode) {
        this.costSharingSourceAccountChartOfAccountsCode = costSharingSourceAccountChartOfAccountsCode;
    }
}

