/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.gl.businessobject.CorrectionChangeGroup;
import org.kuali.kfs.gl.businessobject.CorrectionCriteria;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.options.LaborOriginEntryFieldFinder;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class CorrectionDocumentUtils {
    private CorrectionDocumentUtils() {
    }

    public static boolean laborEntryMatchesCriteria(CorrectionCriteria cc, OriginEntryFull oe) {
        LaborOriginEntryFieldFinder loeff = new LaborOriginEntryFieldFinder();
        LaborOriginEntry loe = (LaborOriginEntry)oe;
        Object fieldActualValue = loe.getFieldValue(cc.getCorrectionFieldName());
        String fieldTestValue = StringUtils.isBlank((CharSequence)cc.getCorrectionFieldValue()) ? "" : cc.getCorrectionFieldValue();
        String fieldType = loeff.getFieldType(cc.getCorrectionFieldName());
        String fieldActualValueString = org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)fieldActualValue, (String)fieldType);
        if ("String".equals(fieldType) || "sw".equals(cc.getCorrectionOperatorCode()) || "ew".equals(cc.getCorrectionOperatorCode()) || "ct".equals(cc.getCorrectionOperatorCode())) {
            return org.kuali.kfs.gl.document.CorrectionDocumentUtils.compareStringData((CorrectionCriteria)cc, (String)fieldTestValue, (String)fieldActualValueString);
        }
        int compareTo = 0;
        try {
            if (fieldActualValue == null) {
                return false;
            }
            if ("Integer".equals(fieldType)) {
                compareTo = ((Integer)fieldActualValue).compareTo(Integer.parseInt(fieldTestValue));
            }
            if ("KualiDecimal".equals(fieldType)) {
                compareTo = ((KualiDecimal)fieldActualValue).compareTo((AbstractKualiDecimal)new KualiDecimal(Double.parseDouble(fieldTestValue)));
            }
            if ("BigDecimal".equals(fieldType)) {
                compareTo = ((BigDecimal)fieldActualValue).compareTo(BigDecimal.valueOf(Double.parseDouble(fieldTestValue)));
            }
            if ("Date".equals(fieldType)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                compareTo = ((Date)fieldActualValue).compareTo(df.parse(fieldTestValue));
            }
        }
        catch (Exception e) {
            return false;
        }
        return org.kuali.kfs.gl.document.CorrectionDocumentUtils.compareTo((int)compareTo, (String)cc.getCorrectionOperatorCode());
    }

    public static boolean doesLaborEntryMatchAnyCriteriaGroups(OriginEntryFull entry, Collection<CorrectionChangeGroup> groups) {
        boolean anyGroupMatch = false;
        for (CorrectionChangeGroup ccg : groups) {
            int matches = 0;
            for (CorrectionCriteria cc : ccg.getCorrectionCriteria()) {
                if (!CorrectionDocumentUtils.laborEntryMatchesCriteria(cc, entry)) continue;
                ++matches;
            }
            if (matches != ccg.getCorrectionCriteria().size()) continue;
            anyGroupMatch = true;
            break;
        }
        return anyGroupMatch;
    }
}

