/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.BenefitsCalculation;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.PositionObjectBenefit;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocument;
import org.kuali.kfs.module.ld.document.service.LaborPendingEntryConverterService;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.service.LaborPositionObjectBenefitService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public final class LaborPendingEntryGenerator {
    private LaborPendingEntryGenerator() {
    }

    public static List<LaborLedgerPendingEntry> generateExpensePendingEntries(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        ArrayList<LaborLedgerPendingEntry> expensePendingEntries = new ArrayList<LaborLedgerPendingEntry>();
        LaborLedgerPendingEntry expensePendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getExpensePendingEntry(document, accountingLine, sequenceHelper);
        expensePendingEntries.add(expensePendingEntry);
        LaborLedgerPendingEntry expenseA21PendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getExpenseA21PendingEntry(document, accountingLine, sequenceHelper);
        expensePendingEntries.add(expenseA21PendingEntry);
        LaborLedgerPendingEntry expenseA21ReversalPendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getExpenseA21ReversalPendingEntry(document, accountingLine, sequenceHelper);
        expensePendingEntries.add(expenseA21ReversalPendingEntry);
        LaborPendingEntryGenerator.refreshObjectCodeNonUpdateableReferences(expensePendingEntries);
        return expensePendingEntries;
    }

    public static List<LaborLedgerPendingEntry> generateBenefitPendingEntries(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        accountingLine.refreshReferenceObject("laborObject");
        if (ObjectUtils.isNull((Object)((Object)accountingLine.getLaborObject()))) {
            return null;
        }
        String FringeOrSalaryCode = accountingLine.getLaborObject().getFinancialObjectFringeOrSalaryCode();
        if (!"S".equals(FringeOrSalaryCode)) {
            return null;
        }
        Integer payrollFiscalYear = accountingLine.getPayrollEndDateFiscalYear();
        String chartOfAccountsCode = accountingLine.getChartOfAccountsCode();
        String objectCode = accountingLine.getFinancialObjectCode();
        Collection<PositionObjectBenefit> positionObjectBenefits = ((LaborPositionObjectBenefitService)SpringContext.getBean(LaborPositionObjectBenefitService.class)).getActivePositionObjectBenefits(payrollFiscalYear, chartOfAccountsCode, objectCode);
        ArrayList<LaborLedgerPendingEntry> benefitPendingEntries = new ArrayList<LaborLedgerPendingEntry>();
        for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            positionObjectBenefit.setLaborBenefitRateCategoryCode(accountingLine.getAccount().getLaborBenefitRateCategoryCode());
            String fringeBenefitObjectCode = positionObjectBenefit.getBenefitsCalculation().getPositionFringeBenefitObjectCode();
            KualiDecimal benefitAmount = ((LaborBenefitsCalculationService)SpringContext.getBean(LaborBenefitsCalculationService.class)).calculateFringeBenefit(positionObjectBenefit, accountingLine.getAmount(), accountingLine.getAccountNumber(), accountingLine.getSubAccountNumber());
            if (!benefitAmount.isNonZero() || !positionObjectBenefit.getBenefitsCalculation().isActive()) continue;
            ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
            Boolean enableFringeBenefitCalculationByBenefitRate = parameterService.getParameterValueAsBoolean(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
            if (StringUtils.isEmpty((CharSequence)fringeBenefitObjectCode) && enableFringeBenefitCalculationByBenefitRate.booleanValue()) {
                String laborBenefitRateCategoryCode = positionObjectBenefit.getLaborBenefitRateCategoryCode();
                if (StringUtils.isBlank((CharSequence)laborBenefitRateCategoryCode)) {
                    laborBenefitRateCategoryCode = parameterService.getParameterValueAsString(Account.class, "DEFAULT_BENEFIT_RATE_CATEGORY_CODE");
                }
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                fieldValues.put("universityFiscalYear", positionObjectBenefit.getUniversityFiscalYear());
                fieldValues.put("chartOfAccountsCode", positionObjectBenefit.getChartOfAccountsCode());
                fieldValues.put("positionBenefitTypeCode", positionObjectBenefit.getFinancialObjectBenefitsTypeCode());
                fieldValues.put("laborBenefitRateCategoryCode", laborBenefitRateCategoryCode);
                BenefitsCalculation bc = (BenefitsCalculation)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(BenefitsCalculation.class, fieldValues);
                fringeBenefitObjectCode = bc.getPositionFringeBenefitObjectCode();
            }
            List<LaborLedgerPendingEntry> pendingEntries = LaborPendingEntryGenerator.generateBenefitPendingEntries(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
            benefitPendingEntries.addAll(pendingEntries);
        }
        return benefitPendingEntries;
    }

    public static List<LaborLedgerPendingEntry> generateBenefitPendingEntries(LaborLedgerPostingDocument document, ExpenseTransferAccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, KualiDecimal benefitAmount, String fringeBenefitObjectCode) {
        ArrayList<LaborLedgerPendingEntry> benefitPendingEntries = new ArrayList<LaborLedgerPendingEntry>();
        LaborLedgerPendingEntry benefitPendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getBenefitPendingEntry(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
        benefitPendingEntries.add(benefitPendingEntry);
        LaborLedgerPendingEntry benefitA21PendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getBenefitA21PendingEntry(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
        benefitPendingEntries.add(benefitA21PendingEntry);
        LaborLedgerPendingEntry benefitA21ReversalPendingEntry = ((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getBenefitA21ReversalPendingEntry(document, accountingLine, sequenceHelper, benefitAmount, fringeBenefitObjectCode);
        benefitPendingEntries.add(benefitA21ReversalPendingEntry);
        LaborPendingEntryGenerator.refreshObjectCodeNonUpdateableReferences(benefitPendingEntries);
        return benefitPendingEntries;
    }

    public static List<LaborLedgerPendingEntry> generateBenefitClearingPendingEntries(LaborLedgerPostingDocument document, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, String accountNumber, String chartOfAccountsCode) {
        ArrayList<LaborLedgerPendingEntry> benefitClearingPendingEntries = new ArrayList<LaborLedgerPendingEntry>();
        HashMap<String, KualiDecimal> sourceLineBenefitAmountSum = new HashMap<String, KualiDecimal>();
        List sourceAccountingLines = document.getSourceAccountingLines();
        for (ExpenseTransferSourceAccountingLine accountingLine : sourceAccountingLines) {
            LaborPendingEntryGenerator.updateBenefitAmountSum(sourceLineBenefitAmountSum, accountingLine);
        }
        HashMap<String, KualiDecimal> targetLineBenefitAmountSum = new HashMap<String, KualiDecimal>();
        List targetAccountingLines = document.getTargetAccountingLines();
        for (ExpenseTransferTargetAccountingLine accountingLine : targetAccountingLines) {
            LaborPendingEntryGenerator.updateBenefitAmountSum(targetLineBenefitAmountSum, accountingLine);
        }
        HashSet benefitTypeCodes = new HashSet(targetLineBenefitAmountSum.keySet());
        benefitTypeCodes.addAll(sourceLineBenefitAmountSum.keySet());
        for (String benefitTypeCode : benefitTypeCodes) {
            KualiDecimal clearingAmount;
            KualiDecimal targetAmount = KualiDecimal.ZERO;
            if (targetLineBenefitAmountSum.containsKey(benefitTypeCode)) {
                targetAmount = (KualiDecimal)targetLineBenefitAmountSum.get(benefitTypeCode);
            }
            KualiDecimal sourceAmount = KualiDecimal.ZERO;
            if (sourceLineBenefitAmountSum.containsKey(benefitTypeCode)) {
                sourceAmount = (KualiDecimal)sourceLineBenefitAmountSum.get(benefitTypeCode);
            }
            if (!(clearingAmount = (KualiDecimal)sourceAmount.subtract((AbstractKualiDecimal)targetAmount)).isNonZero() || !ObjectUtils.isNotNull((Object)benefitTypeCode)) continue;
            benefitClearingPendingEntries.add(((LaborPendingEntryConverterService)SpringContext.getBean(LaborPendingEntryConverterService.class)).getBenefitClearingPendingEntry(document, sequenceHelper, accountNumber, chartOfAccountsCode, benefitTypeCode, clearingAmount));
        }
        LaborPendingEntryGenerator.refreshObjectCodeNonUpdateableReferences(benefitClearingPendingEntries);
        return benefitClearingPendingEntries;
    }

    protected static void updateBenefitAmountSum(Map<String, KualiDecimal> benefitAmountSumByBenefitType, ExpenseTransferAccountingLine accountingLine) {
        accountingLine.refreshReferenceObject("laborObject");
        if (ObjectUtils.isNull((Object)((Object)accountingLine.getLaborObject()))) {
            return;
        }
        String FringeOrSalaryCode = accountingLine.getLaborObject().getFinancialObjectFringeOrSalaryCode();
        if (!"S".equals(FringeOrSalaryCode)) {
            return;
        }
        Integer payrollFiscalYear = accountingLine.getPayrollEndDateFiscalYear();
        String chartOfAccountsCode = accountingLine.getChartOfAccountsCode();
        String objectCode = accountingLine.getFinancialObjectCode();
        Collection<PositionObjectBenefit> positionObjectBenefits = ((LaborPositionObjectBenefitService)SpringContext.getBean(LaborPositionObjectBenefitService.class)).getActivePositionObjectBenefits(payrollFiscalYear, chartOfAccountsCode, objectCode);
        for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            positionObjectBenefit.setLaborBenefitRateCategoryCode(accountingLine.getAccount().getLaborBenefitRateCategoryCode());
            String benefitTypeCode = positionObjectBenefit.getBenefitsCalculation().getPositionBenefitTypeCode();
            KualiDecimal benefitAmount = ((LaborBenefitsCalculationService)SpringContext.getBean(LaborBenefitsCalculationService.class)).calculateFringeBenefit(positionObjectBenefit, accountingLine.getAmount(), accountingLine.getAccountNumber(), accountingLine.getSubAccountNumber());
            if (benefitAmountSumByBenefitType.containsKey(benefitTypeCode)) {
                benefitAmount = (KualiDecimal)benefitAmount.add((AbstractKualiDecimal)benefitAmountSumByBenefitType.get(benefitTypeCode));
            }
            benefitAmountSumByBenefitType.put(benefitTypeCode, benefitAmount);
        }
    }

    protected static void refreshObjectCodeNonUpdateableReferences(List<LaborLedgerPendingEntry> llpes) {
        BusinessObjectService bos = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        for (LaborLedgerPendingEntry llpe : llpes) {
            primaryKeys.put("financialObjectCode", llpe.getFinancialObjectCode());
            ObjectCode objectCode = (ObjectCode)bos.findByPrimaryKey(ObjectCode.class, primaryKeys);
            llpe.setFinancialObject(objectCode);
        }
    }
}

