/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocumentBase;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.Correctable;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public abstract class LaborExpenseTransferDocumentBase
extends LaborLedgerPostingDocumentBase
implements AmountTotaling,
Copyable,
Correctable,
LaborExpenseTransferDocument {
    protected static final Logger LOG = LogManager.getLogger(LaborExpenseTransferDocumentBase.class);
    protected String emplid;
    protected Person user;

    public Map<String, KualiDecimal> getUnbalancedObjectCodes() {
        Map<String, KualiDecimal> amountsFromSourceLine = this.summerizeByObjectCode(this.getSourceAccountingLines());
        Map<String, KualiDecimal> amountsFromTargetLine = this.summerizeByObjectCode(this.getTargetAccountingLines());
        HashMap<String, KualiDecimal> unbalancedAmounts = new HashMap<String, KualiDecimal>();
        for (String objectCode : amountsFromSourceLine.keySet()) {
            KualiDecimal sourceAmount = amountsFromSourceLine.get(objectCode);
            if (!amountsFromTargetLine.containsKey(objectCode)) {
                unbalancedAmounts.put(objectCode, (KualiDecimal)sourceAmount.negated());
                continue;
            }
            KualiDecimal targetAmount = amountsFromTargetLine.get(objectCode);
            KualiDecimal amountDifference = (KualiDecimal)targetAmount.subtract((AbstractKualiDecimal)sourceAmount);
            if (!amountDifference.isNonZero()) continue;
            unbalancedAmounts.put(objectCode, amountDifference);
        }
        for (String objectCode : amountsFromTargetLine.keySet()) {
            if (amountsFromSourceLine.containsKey(objectCode)) continue;
            KualiDecimal targetAmount = amountsFromTargetLine.get(objectCode);
            unbalancedAmounts.put(objectCode, targetAmount);
        }
        return unbalancedAmounts;
    }

    protected Map<String, KualiDecimal> summerizeByObjectCode(List accountingLines) {
        HashMap<String, KualiDecimal> amountByObjectCode = new HashMap<String, KualiDecimal>();
        for (Object accountingLine : accountingLines) {
            AccountingLine line = (AccountingLine)accountingLine;
            String objectCode = line.getFinancialObjectCode();
            KualiDecimal amount = line.getAmount();
            if (amountByObjectCode.containsKey(objectCode)) {
                amount = (KualiDecimal)amount.add((AbstractKualiDecimal)((KualiDecimal)amountByObjectCode.get(objectCode)));
            }
            amountByObjectCode.put(objectCode, amount);
        }
        return amountByObjectCode;
    }

    @Override
    public String getEmplid() {
        return this.emplid;
    }

    @Override
    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public Person getUser() {
        if (this.user == null || !StringUtils.equals((CharSequence)this.user.getEmployeeId(), (CharSequence)this.emplid)) {
            this.user = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByEmployeeId(this.emplid);
        }
        if (this.user == null && this.emplid == null) {
            this.user = new PersonImpl();
        }
        return this.user;
    }

    public void setUser(Person user) {
        this.user = user;
    }

    public String getSourceAccountingLinesSectionTitle() {
        return "From";
    }

    public String getTargetAccountingLinesSectionTitle() {
        return "To";
    }

    public Class getSourceAccountingLineClass() {
        return ExpenseTransferSourceAccountingLine.class;
    }

    public Class getTargetAccountingLineClass() {
        return ExpenseTransferTargetAccountingLine.class;
    }
}

