/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.document.GeneralLedgerCorrectionProcessDocument;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.kns.bo.Step;
import org.kuali.kfs.module.ld.batch.LaborCorrectionProcessScrubberStep;
import org.kuali.kfs.module.ld.document.service.LaborCorrectionDocumentService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryGroupService;
import org.kuali.kfs.sys.batch.BatchSpringContext;
import org.kuali.kfs.sys.context.ProxyUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class LedgerCorrectionDocument
extends GeneralLedgerCorrectionProcessDocument {
    private static final Logger LOG = LogManager.getLogger(LedgerCorrectionDocument.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        if (this.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("X");
        } else if (this.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("R");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("D");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentStatusCode("A");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Document: " + statusChangeEvent.getDocumentId() + " -- Status is: " + this.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode());
        }
        if (!this.getDocumentHeader().getWorkflowDocument().isProcessed()) return;
        String docId = this.getDocumentNumber();
        if (LOG.isInfoEnabled()) {
            LOG.info("Document " + docId + " moving to Processed Status - starting final processing");
        }
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        OriginEntryGroupService originEntryGroupService = (OriginEntryGroupService)SpringContext.getBean(LaborOriginEntryGroupService.class);
        LedgerCorrectionDocument doc = laborCorrectionDocumentService.findByCorrectionDocumentHeaderId(docId);
        String correctionType = doc.getCorrectionTypeCode();
        if ("R".equals(correctionType)) {
            String dataFileName = doc.getCorrectionInputFileName();
            String doneFileName = dataFileName.replace(".data", ".done");
            originEntryGroupService.deleteFile(doneFileName);
            if (LOG.isInfoEnabled()) {
                LOG.info("Document " + docId + " : deleted done file to remove from processing: " + doneFileName);
            }
        } else {
            if ("M".equals(correctionType) || "C".equals(correctionType)) {
                Class<LaborCorrectionDocumentService> clazz = LaborCorrectionDocumentService.class;
                synchronized (LaborCorrectionDocumentService.class) {
                    if (!this.checkForExistingOutputDocument(docId)) {
                        Date today = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
                        String outputFileName = "";
                        if (!doc.getCorrectionFileDelete()) {
                            outputFileName = laborCorrectionDocumentService.createOutputFileForProcessing(docId, today);
                        } else if (LOG.isInfoEnabled()) {
                            LOG.info("Document " + docId + " : set to delete output file - no file will be created");
                        }
                        doc.setCorrectionOutputFileName(outputFileName);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Document " + docId + " : about to run scrubber -- output file: " + outputFileName);
                        }
                        Step step = BatchSpringContext.getStep((String)"laborCorrectionProcessScrubberStep");
                        LaborCorrectionProcessScrubberStep correctionStep = (LaborCorrectionProcessScrubberStep)((Object)ProxyUtils.getTargetIfProxied((Object)step));
                        correctionStep.setDocumentId(docId);
                        try {
                            step.execute(((Object)((Object)this)).getClass().getName(), today);
                        }
                        catch (Exception e) {
                            LOG.error("LLCP scrubber encountered error:", (Throwable)e);
                            throw new RuntimeException("LLCP scrubber encountered error:", e);
                        }
                        correctionStep.setDocumentId(null);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Document " + docId + " : completed scrubber run -- generating reports");
                        }
                        laborCorrectionDocumentService.generateCorrectionReport(this);
                        laborCorrectionDocumentService.aggregateCorrectionDocumentReports(this);
                    } else {
                        LOG.warn("Attempt to re-process final LLCP operations for document: " + docId + "  File with that document number already exists.");
                    }
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                }
            }
            LOG.error("LLCP doc " + docId + " has an unknown correction type code: " + correctionType);
        }
        {
            if (!LOG.isInfoEnabled()) return;
            LOG.info("Document " + docId + " moving to Processed Status - completed final processing");
            return;
        }
    }
}

