/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.module.ld.util.LaborLedgerUnitOfWork;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class LaborLedgerUnitOfWorkTest {
    private LaborLedgerUnitOfWork cut;
    private LaborOriginEntry laborOriginEntry;
    @Mock
    private ParameterService parameterSvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerUnitOfWork.properties";
        Properties properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE")).thenReturn((Object)"ACLO");
        this.laborOriginEntry = (LaborOriginEntry)TestDataPreparator.buildTestDataObject(LaborOriginEntry.class, (Properties)properties);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            this.cut = new LaborLedgerUnitOfWork(this.laborOriginEntry);
        }
    }

    @Test
    public void laborLedgerUnitOfWork() {
        String charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assert.assertEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
    }

    @Test
    public void resetLaborLedgerUnitOfWork() {
        this.cut = new LaborLedgerUnitOfWork();
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        String charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assert.assertEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("financialObjectCode");
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry, keyList);
        charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assert.assertNotEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
        String objectCode = this.cut.getWorkingEntry().getFinancialObjectCode();
        Assert.assertEquals((Object)objectCode, (Object)this.laborOriginEntry.getFinancialObjectCode());
    }

    @Test
    public void addEntryIntoUnit() {
        Assert.assertEquals((long)1L, (long)this.cut.getNumOfMember());
        Assert.assertTrue((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assert.assertEquals((long)2L, (long)this.cut.getNumOfMember());
        Assert.assertTrue((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assert.assertEquals((long)3L, (long)this.cut.getNumOfMember());
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assert.assertFalse((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assert.assertNotEquals((long)4L, (long)this.cut.getNumOfMember());
    }

    @Test
    public void canContain() {
        this.cut = new LaborLedgerUnitOfWork();
        Assert.assertFalse((boolean)this.cut.canContain(this.laborOriginEntry));
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        Assert.assertTrue((boolean)this.cut.canContain(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assert.assertFalse((boolean)this.cut.canContain(this.laborOriginEntry));
    }

    @Test
    public void hasSameKey() {
        this.cut = new LaborLedgerUnitOfWork();
        Assert.assertFalse((boolean)this.cut.hasSameKey(this.laborOriginEntry));
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        Assert.assertTrue((boolean)this.cut.hasSameKey(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assert.assertFalse((boolean)this.cut.hasSameKey(this.laborOriginEntry));
    }
}

