/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.service.BalanceTypeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.sys.businessobject.AccountingLineParserBase;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.AccountingLineParserException;

public class LaborJournalVoucherAccountingLineParser
extends AccountingLineParserBase {
    private String balanceTypeCode;
    protected static final String[] LABOR_JV_FORMAT = new String[]{"chartOfAccountsCode", "accountNumber", "subAccountNumber", "financialObjectCode", "objectTypeCode", "financialSubObjectCode", "projectCode", "organizationReferenceId", "positionNumber", "emplid", "employeeRecord", "earnCode", "payGroup", "salaryAdministrationPlan", "grade", "runIdentifier", "payPeriodEndDate", "payrollEndDateFiscalYear", "payrollEndDateFiscalPeriodCode", "transactionTotalHours", "laborLedgerOriginalChartOfAccountsCode", "laborLedgerOriginalAccountNumber", "laborLedgerOriginalSubAccountNumber", "laborLedgerOriginalFinancialObjectCode", "laborLedgerOriginalFinancialSubObjectCode", "hrmsCompany", "encumbranceUpdateCode", "setid", "debit", "credit"};

    public LaborJournalVoucherAccountingLineParser(String balanceTypeCode) {
        this.balanceTypeCode = balanceTypeCode;
    }

    protected void performCustomSourceAccountingLinePopulation(Map<String, String> attributeValueMap, SourceAccountingLine sourceAccountingLine, String accountingLineAsString) {
        String debitValue = attributeValueMap.remove("debit");
        String creditValue = attributeValueMap.remove("credit");
        KualiDecimal debitAmount = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)debitValue)) {
                debitAmount = new KualiDecimal(debitValue);
            }
        }
        catch (NumberFormatException e) {
            String[] errorParameters = new String[]{debitValue, this.retrieveAttributeLabel(sourceAccountingLine.getClass(), "debit"), accountingLineAsString};
            throw new AccountingLineParserException("invalid (NaN) 'debit=" + debitValue + " for " + accountingLineAsString, "error.accountingLineParser.invalidPropertyValue", errorParameters);
        }
        KualiDecimal creditAmount = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)creditValue)) {
                creditAmount = new KualiDecimal(creditValue);
            }
        }
        catch (NumberFormatException e) {
            String[] errorParameters = new String[]{creditValue, this.retrieveAttributeLabel(sourceAccountingLine.getClass(), "credit"), accountingLineAsString};
            throw new AccountingLineParserException("invalid (NaN) 'credit=" + creditValue + " for " + accountingLineAsString, "error.accountingLineParser.invalidPropertyValue", errorParameters);
        }
        KualiDecimal amount = null;
        String debitCreditCode = null;
        if (debitAmount != null && debitAmount.isNonZero()) {
            amount = debitAmount;
            debitCreditCode = "D";
        }
        if (creditAmount != null && creditAmount.isNonZero()) {
            amount = creditAmount;
            debitCreditCode = "C";
        }
        sourceAccountingLine.setAmount(amount);
        sourceAccountingLine.setDebitCreditCode(debitCreditCode);
        boolean isFinancialOffsetGeneration = ((BalanceTypeService)SpringContext.getBean(BalanceTypeService.class)).getBalanceTypeByCode(this.balanceTypeCode).isFinancialOffsetGenerationIndicator();
        if (isFinancialOffsetGeneration || StringUtils.equals((CharSequence)this.balanceTypeCode, (CharSequence)"EX")) {
            super.performCustomSourceAccountingLinePopulation(attributeValueMap, sourceAccountingLine, accountingLineAsString);
        }
        sourceAccountingLine.setBalanceTypeCode(this.balanceTypeCode);
    }

    public String[] getSourceAccountingLineFormat() {
        return this.removeChartFromFormatIfNeeded(this.selectFormat());
    }

    private String[] selectFormat() {
        return LABOR_JV_FORMAT;
    }
}

