/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.lookup.LedgerBalanceForExpenseTransferLookupableHelperServiceImpl;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.service.OptionsService;

public class LedgerBalanceForSalaryExpenseTransferLookupableHelperServiceImpl
extends LedgerBalanceForExpenseTransferLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    private OptionsService optionsService;

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LOG.debug("Start getSearchResults()");
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String fiscalYearString = fieldValues.get("universityFiscalYear");
        SystemOptions options = this.getOptions(fiscalYearString);
        if (ObjectUtils.isNull((Object)options)) {
            return new CollectionIncomplete(new ArrayList(), Long.valueOf(0L));
        }
        fieldValues.put("financialObjectTypeCode", options.getFinObjTypeExpenditureexpCd());
        fieldValues.put("laborObject.financialObjectFringeOrSalaryCode", "S");
        fieldValues.put("financialBalanceTypeCode", options.getActualFinancialBalanceTypeCd());
        Collection actualBalances = this.buildDetailedBalanceCollection(this.balanceService.findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), true), "No");
        fieldValues.put("financialBalanceTypeCode", "A2");
        Collection effortBalances = this.buildDetailedBalanceCollection(this.balanceService.findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), true), "No");
        List<String> consolidationKeyList = LedgerBalance.getPrimaryKeyList();
        Collection<LedgerBalance> consolidatedBalances = ConsolidationUtil.consolidateA2Balances(actualBalances, effortBalances, options.getActualFinancialBalanceTypeCd(), consolidationKeyList);
        Integer recordCount = this.balanceService.getBalanceRecordCount(fieldValues, true, this.getEncumbranceBalanceTypes(fieldValues), true);
        Long actualSize = OJBUtility.getResultActualSize(consolidatedBalances, (Integer)recordCount, fieldValues, (Object)((Object)new LedgerBalance()));
        return this.buildSearchResultList(consolidatedBalances, actualSize);
    }

    public void validateSearchParameters(Map fieldValues) {
        String employeeId;
        String fiscalYearString = (String)fieldValues.get("universityFiscalYear");
        SystemOptions options = this.getOptions(fiscalYearString);
        if (ObjectUtils.isNull((Object)options) || StringUtils.isBlank((CharSequence)fiscalYearString)) {
            String label = this.dataDictionaryService.getAttributeLabel(LedgerBalance.class, "universityFiscalYear");
            GlobalVariables.getMessageMap().putError("universityFiscalYear", "error.existence", new String[]{label});
        }
        if (StringUtils.isBlank((CharSequence)(employeeId = (String)fieldValues.get("emplid")))) {
            String label = this.dataDictionaryService.getAttributeLabel(LedgerBalance.class, "emplid");
            GlobalVariables.getMessageMap().putError("emplid", "error.labor.missingEmployeeIdError", new String[]{label});
        }
    }

    private SystemOptions getOptions(String fiscalYearString) {
        SystemOptions options;
        if (StringUtils.isBlank((CharSequence)fiscalYearString)) {
            options = this.optionsService.getCurrentYearOptions();
        } else {
            Integer fiscalYear = Integer.valueOf(fiscalYearString.trim());
            options = this.optionsService.getOptions(fiscalYear);
        }
        return options;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

