/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborExpenseTransfeAmountValidValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;
    private AccountingDocument accountingDocumentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AccountingLine accountingLine = this.getAccountingLineForValidation();
        if (!this.isAmountValid(this.accountingDocumentForValidation, accountingLine)) {
            GlobalVariables.getMessageMap().putError("amount", "error.zeroAmount", new String[]{"an accounting line"});
            return false;
        }
        return true;
    }

    public boolean isAmountValid(AccountingDocument document, AccountingLine accountingLine) {
        KualiDecimal amount = accountingLine.getAmount();
        if (amount.isZero()) {
            GlobalVariables.getMessageMap().putError("amount", "error.zeroAmount", new String[]{"an accounting line"});
            return false;
        }
        return true;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingLineForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }
}

