/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LateAdjustment;
import org.kuali.kfs.module.ld.document.LateAdjustable;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LateAdjustmentValidation
extends GenericValidation {
    private static final Logger LOG = LogManager.getLogger();

    public boolean validate(AttributedDocumentEvent event) {
        int numBlankFields = this.lateAdjustmentBlankFieldsCheck((LateAdjustable)event.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("numBlankFields: " + numBlankFields);
        }
        if (numBlankFields > 0 && numBlankFields < 4) {
            GlobalVariables.getMessageMap().putErrorForSectionId("document.lateAdjustment", "error.lateAdjustment.fieldsReq", new String[0]);
            return false;
        }
        return true;
    }

    public int lateAdjustmentBlankFieldsCheck(LateAdjustable document) {
        int blankFieldCount = 0;
        LateAdjustment ecTab = document.getLateAdjustment();
        if (StringUtils.isBlank((CharSequence)ecTab.getExpenditureDescription())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((CharSequence)ecTab.getExpenditureProjectBenefit())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((CharSequence)ecTab.getLateAdjustmentDescription())) {
            ++blankFieldCount;
        }
        if (StringUtils.isBlank((CharSequence)ecTab.getLateAdjustmentReason())) {
            ++blankFieldCount;
        }
        return blankFieldCount;
    }
}

