/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class SalaryExpenseTransferAccountingLinesNoSalariesWagesValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        Account account;
        boolean result = true;
        AccountingLine accountingLine = this.getAccountingLineForValidation();
        if (accountingLine.isTargetAccountingLine() && !this.isValidSubjectFund(account = this.accountFromLine(accountingLine))) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.invalidSalaryAccountSubFund", new String[]{account.getChartOfAccountsCode(), account.getAccountNumber()});
            result = false;
        }
        return result;
    }

    protected boolean isValidSubjectFund(Account account) {
        return account.getSubFundGroup().isSubFundGroupWagesIndicator();
    }

    protected Account accountFromLine(AccountingLine accountingLine) {
        ExpenseTransferAccountingLine expenseTransferAccountingLine = (ExpenseTransferAccountingLine)accountingLine;
        expenseTransferAccountingLine.refreshReferenceObject("laborObject");
        return expenseTransferAccountingLine.getAccount();
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

