/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Map;
import java.util.Set;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class SalaryExpenseTransferObjectCodeBalancesUnchangedValidation
extends GenericValidation {
    private AccountingDocument accountingDocumentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        AccountingDocument accountingDocumentForValidation = this.getAccountingDocumentForValidation();
        SalaryExpenseTransferDocument salaryExpenseTransferDocument = (SalaryExpenseTransferDocument)accountingDocumentForValidation;
        Map<String, KualiDecimal> approvalObjectCodeBalances = salaryExpenseTransferDocument.getApprovalObjectCodeBalances();
        boolean unBalanced = approvalObjectCodeBalances != null && approvalObjectCodeBalances.isEmpty();
        Map<String, KualiDecimal> unbalancedObjectCodes = salaryExpenseTransferDocument.getUnbalancedObjectCodes();
        if ((unBalanced &= unbalancedObjectCodes == null || !unbalancedObjectCodes.isEmpty()) || !this.isObjectCodeBalancesUnchanged(salaryExpenseTransferDocument)) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.transferAmountByObjectApprovalChange", new String[0]);
            result = false;
        }
        return result;
    }

    protected boolean isObjectCodeBalancesUnchanged(SalaryExpenseTransferDocument salaryExpenseTransferDocument) {
        Set<Map.Entry<String, KualiDecimal>> currentObjectCodes;
        boolean isUnchanged = true;
        Map<String, KualiDecimal> initiatedObjectCodeBalances = salaryExpenseTransferDocument.getApprovalObjectCodeBalances();
        Map<String, KualiDecimal> currentObjectCodeBalances = salaryExpenseTransferDocument.getUnbalancedObjectCodes();
        Set<Map.Entry<String, KualiDecimal>> initiatedObjectCodes = initiatedObjectCodeBalances.entrySet();
        if (!initiatedObjectCodes.equals(currentObjectCodes = currentObjectCodeBalances.entrySet())) {
            isUnchanged = false;
        }
        return isUnchanged;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }
}

