/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.SalaryTransferPeriodValidationService;
import org.kuali.kfs.module.ld.document.web.struts.ExpenseTransferDocumentActionBase;
import org.kuali.kfs.module.ld.document.web.struts.ExpenseTransferDocumentFormBase;
import org.kuali.kfs.module.ld.document.web.struts.SalaryExpenseTransferForm;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;

public class SalaryExpenseTransferAction
extends ExpenseTransferDocumentActionBase {
    @Override
    protected void resetLookupFields(ExpenseTransferDocumentFormBase expenseTransferDocumentForm, LedgerBalance balance) {
        SalaryExpenseTransferForm expenseTransferForm = (SalaryExpenseTransferForm)expenseTransferDocumentForm;
        expenseTransferForm.getSalaryExpenseTransferDocument().setEmplid(balance.getEmplid());
        ObjectUtil.buildObject((Object)expenseTransferForm, (Object)((Object)balance));
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        SalaryExpenseTransferDocument salaryExpenseDocument = (SalaryExpenseTransferDocument)((KualiDocumentFormBase)form).getDocument();
        if (salaryExpenseDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested()) {
            salaryExpenseDocument.setApprovalObjectCodeBalances(salaryExpenseDocument.getUnbalancedObjectCodes());
        }
        return forward;
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = this.doEffortCertificationValidation(mapping, form, request, response, "route");
        if (forward != null) {
            return forward;
        }
        return super.route(mapping, form, request, response);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = this.doEffortCertificationValidation(mapping, form, request, response, "approve");
        if (forward != null) {
            return forward;
        }
        return super.approve(mapping, form, request, response);
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = this.doEffortCertificationValidation(mapping, form, request, response, "blanketApprove");
        if (forward != null) {
            return forward;
        }
        return super.blanketApprove(mapping, form, request, response);
    }

    protected ActionForward doEffortCertificationValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String caller) throws Exception {
        SalaryExpenseTransferDocument salaryExpenseDocument = (SalaryExpenseTransferDocument)((KualiDocumentFormBase)form).getDocument();
        boolean doEffortValidation = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(SalaryExpenseTransferDocument.class, "VALIDATE_AGAINST_EFFORT_CERTIFICATION_IND");
        if (!doEffortValidation) {
            return null;
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            boolean transferValid = ((SalaryTransferPeriodValidationService)SpringContext.getBean(SalaryTransferPeriodValidationService.class)).validateTransfers(salaryExpenseDocument);
            if (!transferValid) {
                return this.handleEffortValidationErrors(mapping, form, request, response, caller, false);
            }
        } else {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("EffortValidationOverrideQuestion".equals(question) && "1".equals(buttonClicked)) {
                return this.handleEffortValidationErrors(mapping, form, request, response, caller, true);
            }
        }
        return null;
    }

    protected ActionForward handleEffortValidationErrors(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String caller, boolean questionAsked) throws Exception {
        SalaryExpenseTransferDocument salaryExpenseDocument = (SalaryExpenseTransferDocument)((KualiDocumentFormBase)form).getDocument();
        TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)salaryExpenseDocument);
        boolean isAdmin = documentAuthorizer.isAuthorized((BusinessObject)salaryExpenseDocument, "KFS-LD", "Override Transfer Impacting Open Effort Certification", GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (isAdmin && !questionAsked) {
            String errorMsg;
            ConfigurationService kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
            Object message = "";
            if (GlobalVariables.getMessageMap().doesPropertyHaveError("sourceAccountingLines")) {
                for (Object errorMessage : GlobalVariables.getMessageMap().getMessages("sourceAccountingLines")) {
                    errorMsg = kualiConfigurationService.getPropertyValueAsString(((ErrorMessage)errorMessage).getErrorKey());
                    message = (String)message + MessageFormat.format(errorMsg, ((ErrorMessage)errorMessage).getMessageParameters());
                }
            }
            if (GlobalVariables.getMessageMap().doesPropertyHaveError("targetAccountingLines")) {
                for (Object errorMessage : GlobalVariables.getMessageMap().getMessages("targetAccountingLines")) {
                    errorMsg = kualiConfigurationService.getPropertyValueAsString(((ErrorMessage)errorMessage).getErrorKey());
                    message = (String)message + MessageFormat.format(errorMsg, ((ErrorMessage)errorMessage).getMessageParameters());
                }
            }
            message = (String)message + " " + kualiConfigurationService.getPropertyValueAsString("message.labor.effortValidationOverride");
            return this.performQuestionWithoutInput(mapping, form, request, response, "EffortValidationOverrideQuestion", (String)message, "confirmationQuestion", caller, "");
        }
        if (salaryExpenseDocument.getDocumentHeader().getWorkflowDocument().isEnroute()) {
            ((SalaryTransferPeriodValidationService)SpringContext.getBean(SalaryTransferPeriodValidationService.class)).disapproveSalaryExpenseDocument(salaryExpenseDocument);
            return this.returnToSender(request, mapping, (KualiDocumentFormBase)form);
        }
        return mapping.findForward("basic");
    }
}

