/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerPendingEntryDao;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocument;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborLedgerPendingEntryServiceImpl
implements LaborLedgerPendingEntryService {
    private static final Logger LOG = LogManager.getLogger();
    private LaborLedgerPendingEntryDao laborLedgerPendingEntryDao;
    private BusinessObjectService businessObjectService;
    protected UniversityDateService universityDateService;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private LookupService lookupService;

    @Override
    public boolean hasPendingLaborLedgerEntry(String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("chartOfAccountsCode", chartOfAccountsCode);
        fieldValues.put("accountNumber", accountNumber);
        return this.businessObjectService.countMatching(LaborLedgerPendingEntry.class, fieldValues) > 0;
    }

    @Override
    public boolean hasPendingLaborLedgerEntry(Map fieldValues) {
        LOG.debug("hasPendingLaborLedgerEntry(Map fieldValues) started");
        Collection pendingEntries = this.lookupService.findCollectionBySearch(LaborLedgerPendingEntry.class, fieldValues);
        for (LaborLedgerPendingEntry pendingLedgerEntry : pendingEntries) {
            String approvedCode = pendingLedgerEntry.getFinancialDocumentApprovedCode();
            if ("X".equals(approvedCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean generateLaborLedgerPendingEntries(LaborLedgerPostingDocument document) {
        LOG.debug("generateLaborLedgerPendingEntries() started");
        boolean success = true;
        document.getLaborLedgerPendingEntries().clear();
        LOG.info("deleting existing labor ledger pending ledger entries for document " + document.getDocumentNumber());
        this.delete(document.getDocumentNumber());
        LOG.info("generating labor ledger pending ledger entries for document " + document.getDocumentNumber());
        GeneralLedgerPendingEntrySequenceHelper sequenceHelper = new GeneralLedgerPendingEntrySequenceHelper();
        List sourceAccountingLines = document.getSourceAccountingLines();
        for (AccountingLine accountingLine : sourceAccountingLines) {
            success &= document.generateLaborLedgerPendingEntries(accountingLine, sequenceHelper);
        }
        List targetAccountingLines = document.getTargetAccountingLines();
        for (AccountingLine accountingLine : targetAccountingLines) {
            success &= document.generateLaborLedgerPendingEntries(accountingLine, sequenceHelper);
        }
        return success &= document.generateLaborLedgerBenefitClearingPendingEntries(sequenceHelper);
    }

    @Override
    public void delete(String documentHeaderId) {
        LOG.debug("delete() started");
        this.laborLedgerPendingEntryDao.delete(documentHeaderId);
    }

    @Override
    public Collection findPendingEntries(Map fieldValues, boolean isApproved) {
        LOG.debug("findPendingEntries() started");
        UniversityDate currentUniversityDate = this.universityDateService.getCurrentUniversityDate();
        String currentFiscalPeriodCode = currentUniversityDate.getUniversityFiscalAccountingPeriod();
        Integer currentFiscalYear = currentUniversityDate.getUniversityFiscalYear();
        List encumbranceBalanceTypes = this.generalLedgerPendingEntryService.getEncumbranceBalanceTypes(fieldValues, currentFiscalYear);
        return this.laborLedgerPendingEntryDao.findPendingEntries(fieldValues, isApproved, currentFiscalPeriodCode, currentFiscalYear, encumbranceBalanceTypes);
    }

    @Override
    public Iterator findPendingLedgerEntriesForLedgerBalance(Map fieldValues, boolean isApproved) {
        LOG.debug("findPendingLedgerEntriesForAccountBalance() started");
        UniversityDate currentUniversityDate = this.universityDateService.getCurrentUniversityDate();
        String currentFiscalPeriodCode = currentUniversityDate.getUniversityFiscalAccountingPeriod();
        Integer currentFiscalYear = currentUniversityDate.getUniversityFiscalYear();
        List encumbranceBalanceTypes = this.generalLedgerPendingEntryService.getEncumbranceBalanceTypes(fieldValues, currentFiscalYear);
        return this.laborLedgerPendingEntryDao.findPendingLedgerEntriesForLedgerBalance(fieldValues, isApproved, currentFiscalPeriodCode, currentFiscalYear, encumbranceBalanceTypes);
    }

    @Override
    public Iterator<LaborLedgerPendingEntry> findApprovedPendingLedgerEntries() {
        return this.laborLedgerPendingEntryDao.findApprovedPendingLedgerEntries();
    }

    @Override
    public void deleteByFinancialDocumentApprovedCode(String financialDocumentApprovedCode) {
        this.laborLedgerPendingEntryDao.deleteByFinancialDocumentApprovedCode(financialDocumentApprovedCode);
    }

    public void setLaborLedgerPendingEntryDao(LaborLedgerPendingEntryDao laborLedgerPendingEntryDao) {
        this.laborLedgerPendingEntryDao = laborLedgerPendingEntryDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }
}

