/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LedgerBalanceLookupableHelperServiceIntegTest
extends KualiIntegTestBase {
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private int ledgerBalanceExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"laborLedgerBalanceLookupableHelperService");
        this.lookupableHelperService.setBusinessObjectClass(LedgerBalance.class);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("universityFiscalYear", IntegTestUtils.getFiscalYearForTesting().toString());
        keys.put("emplid", "0000001265");
        keys.put("financialBalanceTypeCode", "AC");
        keys.put("chartOfAccountsCode", "BL");
        this.businessObjectService.deleteMatching(LedgerBalance.class, keys);
    }

    public void testGetSearchResults() {
        this.insertLedgerBalanceRecords();
        LedgerBalance ledgerBalance = new LedgerBalance();
        ledgerBalance.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
        ledgerBalance.setEmplid("0000001265");
        ledgerBalance.setBalanceTypeCode("AC");
        ledgerBalance.setChartOfAccountsCode("BL");
        Map<String, String> fieldValues = this.buildFieldValues(ledgerBalance, this.getLookupFields());
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        if (searchResults != null) {
            System.out.println("Results Size:" + searchResults.size());
        }
        LedgerBalanceLookupableHelperServiceIntegTest.assertEquals((int)this.ledgerBalanceExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(LedgerBalance ledgerBalance, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)ledgerBalance, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields() {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("emplid");
        lookupFields.add("financialBalanceTypeCode");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    protected void insertLedgerBalanceRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/ledgerBalance.properties";
        Properties properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        String documentFieldNames = properties.getProperty("fieldNames");
        String deliminator = properties.getProperty("deliminator");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        int numberOfDocuments = Integer.parseInt(properties.getProperty("getLedgerBalance.numOfData"));
        ArrayList<LedgerBalance> inputDataList = new ArrayList<LedgerBalance>();
        for (int i = 1; i <= numberOfDocuments; ++i) {
            String propertyKey = "getLedgerBalance.testData" + i;
            LedgerBalance inputData = new LedgerBalance();
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)properties, (String)propertyKey, (String)documentFieldNames, (String)deliminator);
            inputData.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        String testTarget = "getLedgerBalance.";
        this.ledgerBalanceExpectedInsertion = Integer.parseInt(properties.getProperty(testTarget + "expectedInsertion"));
        this.businessObjectService.save(inputDataList);
    }
}

