/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.SalaryExpenseTransferDuplicateAccountingLineValidation;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class SalaryExpenseTransferDuplicateAccountingLineValidationTest {
    @Mock
    private SalaryExpenseTransferDocument salaryExpenseTransferDocMock;
    private SalaryExpenseTransferDuplicateAccountingLineValidation cut;
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1031400";
    private static final String SUB_ACCOUNT_NUMBER = "ADV";
    private static final String FINANCIAL_OBJECT_CODE = "2383";
    private static final String FINANCIAL_SUB_OBJECT_CODE = "POS";
    private static final String PROJECT_CODE = "BOB";
    private static final String ORGANIZATION_REFERENCE_ID = "123";
    private static final Integer PAYROLL_END_DATE_FY = 2009;
    private static final String PAYROLL_END_DATE_FISCAL_PERIOD_CODE = "09";
    private static final KualiDecimal AMOUNT = new KualiDecimal(100.0);

    SalaryExpenseTransferDuplicateAccountingLineValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new SalaryExpenseTransferDuplicateAccountingLineValidation();
        this.cut.setAccountingDocumentForValidation((AccountingDocument)this.salaryExpenseTransferDocMock);
    }

    @Test
    void validate_accountingLinesMatch_invalid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        Mockito.when((Object)sourceAccountingLine.getAmount()).thenReturn((Object)AMOUNT);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        Mockito.when((Object)targetAccountingLine.getAmount()).thenReturn((Object)AMOUNT);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentChart_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)"EA");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentAccount_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)"1031420");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentSubAccount_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)"BLT");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentObjectCode_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)"5000");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentSubObjectCode_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)"ABC");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentProjectCode_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)"PRJ");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentOrgRefId_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)"456");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentFiscalYear_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)2010);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentFiscalPeriod_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)"10");
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_targetAccountingLineHasDifferentAmount_valid(@Mock(stubOnly=true) ExpenseTransferSourceAccountingLine sourceAccountingLine, @Mock(stubOnly=true) ExpenseTransferTargetAccountingLine targetAccountingLine) {
        Mockito.when((Object)sourceAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)sourceAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)sourceAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)sourceAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)sourceAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        Mockito.when((Object)sourceAccountingLine.getAmount()).thenReturn((Object)AMOUNT);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(sourceAccountingLine);
        Mockito.when((Object)targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)CHART_OF_ACCOUNTS_CODE);
        Mockito.when((Object)targetAccountingLine.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getSubAccountNumber()).thenReturn((Object)SUB_ACCOUNT_NUMBER);
        Mockito.when((Object)targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)FINANCIAL_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)FINANCIAL_SUB_OBJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getProjectCode()).thenReturn((Object)PROJECT_CODE);
        Mockito.when((Object)targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)ORGANIZATION_REFERENCE_ID);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)PAYROLL_END_DATE_FY);
        Mockito.when((Object)targetAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PAYROLL_END_DATE_FISCAL_PERIOD_CODE);
        Mockito.when((Object)targetAccountingLine.getAmount()).thenReturn((Object)AMOUNT);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        Mockito.when((Object)targetAccountingLine.getAmount()).thenReturn((Object)new KualiDecimal(500.0));
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }
}

