/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.LaborGeneralLedgerEntry;
import org.kuali.kfs.module.ld.service.LaborGeneralLedgerEntryService;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborGeneralLedgerEntryServiceIntegTest
extends KualiIntegTestBase {
    private Properties properties;
    private String fieldNames;
    private String deliminator;
    private List<String> keyFieldList;
    private LaborGeneralLedgerEntryService laborGeneralLedgerEntryService;
    private BusinessObjectService businessObjectService;

    public void setUp() throws Exception {
        super.setUp();
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborGeneralLedgerEntryService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.keyFieldList = Arrays.asList(StringUtils.split((String)this.fieldNames, (String)this.deliminator));
        this.laborGeneralLedgerEntryService = (LaborGeneralLedgerEntryService)SpringContext.getBean(LaborGeneralLedgerEntryService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    public void testSave() {
        LaborGeneralLedgerEntry input1 = new LaborGeneralLedgerEntry();
        ObjectUtil.populateBusinessObject((Object)input1, (Properties)this.properties, (String)"save.testData1", (String)this.fieldNames, (String)this.deliminator);
        LaborGeneralLedgerEntry expected1 = new LaborGeneralLedgerEntry();
        ObjectUtil.populateBusinessObject((Object)expected1, (Properties)this.properties, (String)"save.expected1", (String)this.fieldNames, (String)this.deliminator);
        Map fieldValues = ObjectUtil.buildPropertyMap((Object)expected1, this.keyFieldList);
        this.businessObjectService.deleteMatching(LaborGeneralLedgerEntry.class, fieldValues);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((int)0, (int)this.businessObjectService.countMatching(LaborGeneralLedgerEntry.class, fieldValues));
        this.laborGeneralLedgerEntryService.save(input1);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((int)1, (int)this.businessObjectService.countMatching(LaborGeneralLedgerEntry.class, fieldValues));
        LaborGeneralLedgerEntry input2 = new LaborGeneralLedgerEntry();
        ObjectUtil.populateBusinessObject((Object)input2, (Properties)this.properties, (String)"save.testData2", (String)this.fieldNames, (String)this.deliminator);
        try {
            this.laborGeneralLedgerEntryService.save(input2);
            LaborGeneralLedgerEntryServiceIntegTest.fail();
        }
        catch (PersistenceBrokerSQLException persistenceBrokerSQLException) {
            // empty catch block
        }
    }

    public void testGetMaxSequenceNumber() {
        LaborGeneralLedgerEntry input1 = new LaborGeneralLedgerEntry();
        ObjectUtil.populateBusinessObject((Object)input1, (Properties)this.properties, (String)"maxSeqNumber.testData1", (String)this.fieldNames, (String)this.deliminator);
        Map fieldValues = ObjectUtil.buildPropertyMap((Object)input1, this.keyFieldList);
        fieldValues.remove("transactionLedgerEntrySequenceNumber");
        this.businessObjectService.deleteMatching(LaborGeneralLedgerEntry.class, fieldValues);
        Integer maxSeqNumber = this.laborGeneralLedgerEntryService.getMaxSequenceNumber(input1);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((Object)0, (Object)maxSeqNumber);
        String expectedSeqNumber1 = this.properties.getProperty("maxSeqNumber.expected1");
        this.laborGeneralLedgerEntryService.save(input1);
        maxSeqNumber = this.laborGeneralLedgerEntryService.getMaxSequenceNumber(input1);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((Object)Integer.valueOf(expectedSeqNumber1), (Object)maxSeqNumber);
        LaborGeneralLedgerEntry input2 = new LaborGeneralLedgerEntry();
        ObjectUtil.populateBusinessObject((Object)input2, (Properties)this.properties, (String)"maxSeqNumber.testData2", (String)this.fieldNames, (String)this.deliminator);
        String expectedSeqNumber2 = this.properties.getProperty("maxSeqNumber.expected2");
        this.laborGeneralLedgerEntryService.save(input2);
        maxSeqNumber = this.laborGeneralLedgerEntryService.getMaxSequenceNumber(input1);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((Object)Integer.valueOf(expectedSeqNumber2), (Object)maxSeqNumber);
        maxSeqNumber = this.laborGeneralLedgerEntryService.getMaxSequenceNumber(input2);
        LaborGeneralLedgerEntryServiceIntegTest.assertEquals((Object)Integer.valueOf(expectedSeqNumber2), (Object)maxSeqNumber);
    }
}

