/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.fp.document.JournalVoucherDocument;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.validation.impl.LaborJournalVoucherAccountingPeriodValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.util.AutoPopulatingList;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class LaborJournalVoucherAccountingPeriodValidationTest {
    private LaborJournalVoucherAccountingPeriodValidation cut;
    @Mock
    private AccountingPeriod accountingPeriodMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private JournalVoucherDocument journalVoucherDocMock;
    private static final String LABEL = "Accounting Period";

    LaborJournalVoucherAccountingPeriodValidationTest() {
    }

    @BeforeEach
    void setUp() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut = new LaborJournalVoucherAccountingPeriodValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setJournalVoucherForValidation(this.journalVoucherDocMock);
    }

    @Test
    void validate_VALID(@Mock(stubOnly=true) AttributeDefinition attributeDefinitionMock, @Mock(stubOnly=true) DataDictionaryEntry dataDictionaryEntryMock) {
        Mockito.when((Object)attributeDefinitionMock.getLabel()).thenReturn((Object)LABEL);
        Mockito.when((Object)dataDictionaryEntryMock.getAttributeDefinition("accountingPeriod")).thenReturn((Object)attributeDefinitionMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDictionaryObjectEntry(JournalVoucherDocument.class.getName())).thenReturn((Object)dataDictionaryEntryMock);
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn((Object)this.accountingPeriodMock);
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validate_nullAccountingPeriod_INVALID(@Mock(stubOnly=true) AttributeDefinition attributeDefinitionMock, @Mock(stubOnly=true) DataDictionaryEntry dataDictionaryEntryMock) {
        Mockito.when((Object)attributeDefinitionMock.getLabel()).thenReturn((Object)LABEL);
        Mockito.when((Object)dataDictionaryEntryMock.getAttributeDefinition("accountingPeriod")).thenReturn((Object)attributeDefinitionMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDictionaryObjectEntry(JournalVoucherDocument.class.getName())).thenReturn((Object)dataDictionaryEntryMock);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn((Object)this.accountingPeriodMock);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.selectedAccountingPeriod")).get(0);
        Assertions.assertEquals((Object)"error.existence", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)LABEL, (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void validate_inactiveAccountingPeriod_INVALID(@Mock(stubOnly=true) AttributeDefinition attributeDefinitionMock, @Mock(stubOnly=true) DataDictionaryEntry dataDictionaryEntryMock) {
        Mockito.when((Object)attributeDefinitionMock.getLabel()).thenReturn((Object)LABEL);
        Mockito.when((Object)dataDictionaryEntryMock.getAttributeDefinition("accountingPeriod")).thenReturn((Object)attributeDefinitionMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDictionaryObjectEntry(JournalVoucherDocument.class.getName())).thenReturn((Object)dataDictionaryEntryMock);
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn((Object)this.accountingPeriodMock);
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.selectedAccountingPeriod")).get(0);
        Assertions.assertEquals((Object)"error.document.accountingPeriod.closed", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validate_inactiveAccountingPeriod_A21BalanceType_VALID(@Mock(stubOnly=true) AttributeDefinition attributeDefinitionMock, @Mock(stubOnly=true) DataDictionaryEntry dataDictionaryEntryMock) {
        Mockito.when((Object)attributeDefinitionMock.getLabel()).thenReturn((Object)LABEL);
        Mockito.when((Object)dataDictionaryEntryMock.getAttributeDefinition("accountingPeriod")).thenReturn((Object)attributeDefinitionMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDictionaryObjectEntry(JournalVoucherDocument.class.getName())).thenReturn((Object)dataDictionaryEntryMock);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn((Object)this.accountingPeriodMock);
        Mockito.when((Object)this.journalVoucherDocMock.getBalanceTypeCode()).thenReturn((Object)"A2");
        Assertions.assertTrue((boolean)this.cut.validate(null));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }
}

