/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.module.ld.util.LaborLedgerUnitOfWork;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LaborLedgerUnitOfWorkTest {
    private LaborLedgerUnitOfWork cut;
    private LaborOriginEntry laborOriginEntry;
    @Mock
    private ParameterService parameterSvcMock;

    LaborLedgerUnitOfWorkTest() {
    }

    @BeforeEach
    void setUp() {
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerUnitOfWork.properties";
        Properties properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.laborOriginEntry = (LaborOriginEntry)TestDataPreparator.buildTestDataObject(LaborOriginEntry.class, (Properties)properties);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            this.cut = new LaborLedgerUnitOfWork(this.laborOriginEntry);
        }
    }

    @Test
    void laborLedgerUnitOfWork() {
        String charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assertions.assertEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
    }

    @Test
    void resetLaborLedgerUnitOfWork() {
        this.cut = new LaborLedgerUnitOfWork();
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        String charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assertions.assertEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("financialObjectCode");
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry, keyList);
        charAccountsCode = this.cut.getWorkingEntry().getChartOfAccountsCode();
        Assertions.assertNotEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
        String objectCode = this.cut.getWorkingEntry().getFinancialObjectCode();
        Assertions.assertEquals((Object)objectCode, (Object)this.laborOriginEntry.getFinancialObjectCode());
    }

    @Test
    void addEntryIntoUnit() {
        Assertions.assertEquals((int)1, (int)this.cut.getNumOfMember());
        Assertions.assertTrue((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assertions.assertEquals((int)2, (int)this.cut.getNumOfMember());
        Assertions.assertTrue((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assertions.assertEquals((int)3, (int)this.cut.getNumOfMember());
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assertions.assertFalse((boolean)this.cut.addEntryIntoUnit(this.laborOriginEntry));
        Assertions.assertNotEquals((int)4, (int)this.cut.getNumOfMember());
    }

    @Test
    void canContain() {
        this.cut = new LaborLedgerUnitOfWork();
        Assertions.assertFalse((boolean)this.cut.canContain(this.laborOriginEntry));
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        Assertions.assertTrue((boolean)this.cut.canContain(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assertions.assertFalse((boolean)this.cut.canContain(this.laborOriginEntry));
    }

    @Test
    void hasSameKey() {
        this.cut = new LaborLedgerUnitOfWork();
        Assertions.assertFalse((boolean)this.cut.hasSameKey(this.laborOriginEntry));
        this.cut.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        Assertions.assertTrue((boolean)this.cut.hasSameKey(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        Assertions.assertFalse((boolean)this.cut.hasSameKey(this.laborOriginEntry));
    }
}

