/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import org.kuali.kfs.gl.batch.service.impl.AccountingCycleCachingServiceImpl;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.module.ld.batch.dataaccess.LedgerPreparedStatementCachingDao;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.sys.batch.service.AbstractBatchTransactionalCachingService;

public class LaborAccountingCycleCachingServiceImpl
extends AccountingCycleCachingServiceImpl
implements LaborAccountingCycleCachingService {
    protected LedgerPreparedStatementCachingDao laborLedgerDao;

    public void initialize() {
        super.initialize();
        this.laborLedgerDao.initialize();
        this.previousValueCache.put(LedgerBalance.class, new AbstractBatchTransactionalCachingService.PreviousValueReference((AbstractBatchTransactionalCachingService)this));
    }

    @Override
    public LaborObject getLaborObject(final Integer fiscalYear, final String chartCode, final String objectCode) {
        return (LaborObject)new AbstractBatchTransactionalCachingService.ReferenceValueRetriever<LaborObject>(){

            protected LaborObject useDao() {
                return LaborAccountingCycleCachingServiceImpl.this.laborLedgerDao.getLaborObject(fiscalYear, chartCode, objectCode);
            }

            protected void retrieveReferences(LaborObject laborObject) {
            }
        }.get(LaborObject.class, new Object[]{fiscalYear, chartCode, objectCode});
    }

    @Override
    public int getMaxLaborSequenceNumber(LedgerEntry t) {
        return this.laborLedgerDao.getMaxLaborSequenceNumber(t);
    }

    @Override
    public LedgerBalance getLedgerBalance(final LedgerBalance ledgerBalance) {
        return (LedgerBalance)new AbstractBatchTransactionalCachingService.PreviousValueRetriever<LedgerBalance>(){

            protected LedgerBalance useDao() {
                return LaborAccountingCycleCachingServiceImpl.this.laborLedgerDao.getLedgerBalance(ledgerBalance);
            }
        }.get(LedgerBalance.class, new Object[]{ledgerBalance.getUniversityFiscalYear(), ledgerBalance.getChartOfAccountsCode(), ledgerBalance.getAccountNumber(), ledgerBalance.getSubAccountNumber(), ledgerBalance.getFinancialObjectCode(), ledgerBalance.getFinancialSubObjectCode(), ledgerBalance.getFinancialBalanceTypeCode(), ledgerBalance.getFinancialObjectTypeCode(), ledgerBalance.getPositionNumber(), ledgerBalance.getEmplid()});
    }

    @Override
    public void insertLedgerBalance(LedgerBalance ledgerBalance) {
        this.laborLedgerDao.insertLedgerBalance(ledgerBalance, this.dateTimeService.getCurrentTimestamp());
        ((AbstractBatchTransactionalCachingService.PreviousValueReference)this.previousValueCache.get(LedgerBalance.class)).update((BusinessObject)ledgerBalance, new Object[]{ledgerBalance.getUniversityFiscalYear(), ledgerBalance.getChartOfAccountsCode(), ledgerBalance.getAccountNumber(), ledgerBalance.getSubAccountNumber(), ledgerBalance.getFinancialObjectCode(), ledgerBalance.getFinancialSubObjectCode(), ledgerBalance.getFinancialBalanceTypeCode(), ledgerBalance.getFinancialObjectTypeCode(), ledgerBalance.getPositionNumber(), ledgerBalance.getEmplid()});
    }

    @Override
    public void updateLedgerBalance(LedgerBalance ledgerBalance) {
        this.laborLedgerDao.updateLedgerBalance(ledgerBalance, this.dateTimeService.getCurrentTimestamp());
        ((AbstractBatchTransactionalCachingService.PreviousValueReference)this.previousValueCache.get(LedgerBalance.class)).update((BusinessObject)ledgerBalance, new Object[]{ledgerBalance.getUniversityFiscalYear(), ledgerBalance.getChartOfAccountsCode(), ledgerBalance.getAccountNumber(), ledgerBalance.getSubAccountNumber(), ledgerBalance.getFinancialObjectCode(), ledgerBalance.getFinancialSubObjectCode(), ledgerBalance.getFinancialBalanceTypeCode(), ledgerBalance.getFinancialObjectTypeCode(), ledgerBalance.getPositionNumber(), ledgerBalance.getEmplid()});
    }

    @Override
    public void insertLedgerEntry(LedgerEntry ledgerEntry) {
        this.laborLedgerDao.insertLedgerEntry(ledgerEntry);
    }

    public void setLaborLedgerDao(LedgerPreparedStatementCachingDao laborLedgerDao) {
        this.laborLedgerDao = laborLedgerDao;
    }
}

