/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.apache.ojb.broker.util.ObjectModification;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.module.ld.LaborPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.July1PositionFunding;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborDao;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;

public class LaborDaoOjb
extends PlatformAwareDaoBaseOjb
implements LaborDao {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public Object getEncumbranceTotal(Map fieldValues) {
        Criteria criteria = new Criteria();
        criteria.addAndCriteria(OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new AccountStatusCurrentFunds())));
        ReportQueryByCriteria query = QueryFactory.newReportQuery(AccountStatusCurrentFunds.class, (Criteria)criteria);
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("universityFiscalYear");
        groupByList.add("chartOfAccountsCode");
        groupByList.add("accountNumber");
        groupByList.add("subAccountNumber");
        groupByList.add("financialObjectCode");
        groupByList.add("financialSubObjectCode");
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.setAttributes(new String[]{ConsolidationUtil.sum("ACLN_ANNL_BAL_AMT") + " + " + ConsolidationUtil.sum("CONTR_GR_BB_AC_AMT")});
        query.addGroupBy(groupBy);
        Object[] encumbrances = null;
        Iterator accountStatusCurrentFunds = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (accountStatusCurrentFunds != null && accountStatusCurrentFunds.hasNext()) {
            encumbrances = (Object[])accountStatusCurrentFunds.next();
        }
        KualiDecimal encumbranceTotal = KualiDecimal.ZERO;
        if (encumbrances != null) {
            encumbranceTotal = new KualiDecimal(encumbrances[0].toString());
        }
        return encumbranceTotal;
    }

    @Override
    public Object getPendingEncumbranceTotal(Map fieldValues, String pendingEntryOption) {
        Criteria criteria = new Criteria();
        criteria.addAndCriteria(OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)new LaborLedgerPendingEntry()));
        if ("All".equals(pendingEntryOption)) {
            criteria.addNotEqualTo((Object)"financialDocumentApprovedCode", (Object)"X");
            Criteria subCriteria1 = new Criteria();
            subCriteria1.addNotEqualTo((Object)"financialDocumentApprovedCode", (Object)"X");
            Criteria subCriteria2 = new Criteria();
            subCriteria2.addIsNull("financialDocumentApprovedCode");
            subCriteria1.addOrCriteria(subCriteria2);
            criteria.addAndCriteria(subCriteria1);
        } else {
            criteria.addIn(String.join((CharSequence)".", "documentHeader", "financialDocumentStatusCode"), Collections.singleton(new String[]{"A"}));
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LaborLedgerPendingEntry.class, (Criteria)criteria);
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("universityFiscalYear");
        groupByList.add("chartOfAccountsCode");
        groupByList.add("accountNumber");
        groupByList.add("subAccountNumber");
        groupByList.add("financialObjectCode");
        groupByList.add("financialSubObjectCode");
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.setAttributes(new String[]{ConsolidationUtil.sum("TRN_LDGR_ENTR_AMT")});
        query.addGroupBy(groupBy);
        Object[] encumbrances = null;
        Iterator accountStatusCurrentFunds = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        while (accountStatusCurrentFunds != null && accountStatusCurrentFunds.hasNext()) {
            encumbrances = (Object[])accountStatusCurrentFunds.next();
        }
        KualiDecimal encumbranceTotal = KualiDecimal.ZERO;
        if (encumbrances != null) {
            encumbranceTotal = new KualiDecimal(encumbrances[0].toString());
        }
        return encumbranceTotal;
    }

    @Override
    public Collection getJuly1(Map fieldValues) {
        HashMap fieldCriteria = new HashMap(fieldValues);
        fieldCriteria.remove("financialBalanceTypeCode");
        Criteria criteria = new Criteria();
        criteria.addAndCriteria(OJBUtility.buildCriteriaFromMap(fieldCriteria, (Object)((Object)new July1PositionFunding())));
        QueryByCriteria query = QueryFactory.newQuery(July1PositionFunding.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Iterator getCurrentFunds(Map fieldValues, boolean isConsolidated) {
        Query query = this.getAccountStatusQuery(AccountStatusCurrentFunds.class, fieldValues, isConsolidated);
        OJBUtility.limitResultSize((Query)query);
        if (isConsolidated) {
            return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery(query);
        }
        return this.getPersistenceBrokerTemplate().getIteratorByQuery(query);
    }

    protected <T> Query getAccountStatusQuery(Class<T> clazz, Map fieldValues, boolean isConsolidated) {
        LOG.debug("getAccountStatusQuery(Class<T>, Map, boolean) started");
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = fieldValues::entrySet;
        LOG.debug("Building criteria from map fields: {}", supplierArray);
        Criteria criteria = new Criteria();
        try {
            criteria.addAndCriteria(OJBUtility.buildCriteriaFromMap((Map)fieldValues, clazz.newInstance()));
        }
        catch (Exception e) {
            LOG.error("Could not add and criteria properly for {}", clazz);
            throw new RuntimeException(e);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(clazz, (Criteria)criteria);
        LOG.debug("Built query: {}", (Object)query);
        if (isConsolidated) {
            ConsolidationUtil.buildConsolidatedQuery(query, ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.JULY.propertyName));
        }
        return query;
    }

    @Override
    public Collection<July1PositionFunding> getJuly1PositionFunding(Map<String, String> fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap(fieldValues, (Object)((Object)new July1PositionFunding()));
        criteria.addEqualToField("laborObject.universityFiscalYear", "universityFiscalYear");
        criteria.addEqualToField("laborObject.chartOfAccountsCode", "chartOfAccountsCode");
        criteria.addEqualToField("laborObject.financialObjectCode", "financialObjectCode");
        criteria.addNotNull("laborObject.financialObjectFringeOrSalaryCode");
        QueryByCriteria query = QueryFactory.newQuery(July1PositionFunding.class, (Criteria)criteria);
        OJBUtility.limitResultSize((Query)query);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public void insert(BusinessObject businessObject) {
        this.getPersistenceBroker(true).store((Object)businessObject, ObjectModification.INSERT);
    }
}

