/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.dataaccess.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.gl.dataaccess.LedgerBalanceBalancingDao;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.LaborPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.EmployeeFunding;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceSummary;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForYearEndBalanceForward;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerBalanceDao;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.ObjectUtil;

public class LaborLedgerBalanceDaoOjb
extends PlatformAwareDaoBaseOjb
implements LaborLedgerBalanceDao,
LedgerBalanceBalancingDao {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public Iterator<LedgerBalance> findBalancesForFiscalYear(Integer year) {
        LOG.debug("findBalancesForFiscalYear() started");
        Criteria c = new Criteria();
        c.addEqualTo("universityFiscalYear", (Object)year);
        QueryByCriteria query = QueryFactory.newQuery(LedgerBalance.class, (Criteria)c);
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        query.addOrderByAscending("financialObjectCode");
        query.addOrderByAscending("financialSubObjectCode");
        query.addOrderByAscending("financialBalanceTypeCode");
        query.addOrderByAscending("financialObjectTypeCode");
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
    }

    @Override
    public Iterator<LedgerBalance> findBalancesForFiscalYear(Integer fiscalYear, Map<String, String> fieldValues, List<String> encumbranceBalanceTypes) {
        Criteria criteria = this.buildCriteriaFromMap(fieldValues, new LedgerBalance(), encumbranceBalanceTypes, false);
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        QueryByCriteria query = QueryFactory.newQuery(LedgerBalance.class, (Criteria)criteria);
        query.addOrderByAscending("chartOfAccountsCode");
        query.addOrderByAscending("accountNumber");
        query.addOrderByAscending("subAccountNumber");
        query.addOrderByAscending("financialObjectCode");
        query.addOrderByAscending("financialSubObjectCode");
        query.addOrderByAscending("financialBalanceTypeCode");
        query.addOrderByAscending("financialObjectTypeCode");
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
    }

    @Override
    public Iterator<LedgerBalanceForYearEndBalanceForward> findBalancesForFiscalYear(Integer fiscalYear, Map<String, String> fieldValues, List<String> subFundGroupCodes, List<String> fundGroupCodes) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap(fieldValues, (Object)((Object)new LedgerBalanceForYearEndBalanceForward()));
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        String chartAccountsCode = fieldValues.get("chartOfAccountsCode");
        String accountNumber = fieldValues.get("accountNumber");
        if ((StringUtils.isEmpty((CharSequence)chartAccountsCode) || StringUtils.isEmpty((CharSequence)accountNumber)) && subFundGroupCodes != null && !subFundGroupCodes.isEmpty()) {
            Criteria criteriaForSubFundGroup = new Criteria();
            String subFundGroupFieldName = "account.subFundGroupCode";
            criteriaForSubFundGroup.addIn(subFundGroupFieldName, subFundGroupCodes);
            if (fundGroupCodes != null && !fundGroupCodes.isEmpty()) {
                Criteria criteriaForFundGroup = new Criteria();
                String fundGroupFieldName = "account.subFundGroup.fundGroupCode";
                criteriaForFundGroup.addIn(fundGroupFieldName, fundGroupCodes);
                criteriaForSubFundGroup.addOrCriteria(criteriaForFundGroup);
            }
            criteria.addAndCriteria(criteriaForSubFundGroup);
        }
        QueryByCriteria query = QueryFactory.newQuery(LedgerBalanceForYearEndBalanceForward.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getIteratorByQuery((Query)query);
    }

    @Override
    public Iterator<LedgerBalance> findBalance(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        LOG.debug("findBalance() started");
        Query query = this.getBalanceQuery(fieldValues, isConsolidated, encumbranceBalanceTypes, noZeroAmounts);
        OJBUtility.limitResultSize((Query)query);
        if (isConsolidated) {
            return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery(query);
        }
        return this.getPersistenceBrokerTemplate().getIteratorByQuery(query);
    }

    @Override
    @Deprecated
    public Iterator<LedgerBalance> findBalance(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes) {
        LOG.debug("findBalance() started");
        Query query = this.getBalanceQuery(fieldValues, isConsolidated, encumbranceBalanceTypes, false);
        OJBUtility.limitResultSize((Query)query);
        if (isConsolidated) {
            return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery(query);
        }
        return this.getPersistenceBrokerTemplate().getIteratorByQuery(query);
    }

    @Override
    public Iterator getConsolidatedBalanceRecordCount(Map fieldValues, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        LOG.debug("getBalanceRecordCount() started");
        ReportQueryByCriteria query = this.getBalanceCountQuery(fieldValues, encumbranceBalanceTypes, noZeroAmounts);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    @Override
    @Deprecated
    public Iterator getConsolidatedBalanceRecordCount(Map fieldValues, List<String> encumbranceBalanceTypes) {
        LOG.debug("getBalanceRecordCount() started");
        ReportQueryByCriteria query = this.getBalanceCountQuery(fieldValues, encumbranceBalanceTypes, false);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected Query getBalanceQuery(Map fieldValues, boolean isConsolidated, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = fieldValues::keySet;
        LOG.debug("Building criteria from map fields: {}", supplierArray);
        LOG.debug("getBalanceQuery(Map, boolean) started");
        Criteria criteria = this.buildCriteriaFromMap(fieldValues, new LedgerBalance(), encumbranceBalanceTypes, noZeroAmounts);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalance.class, (Criteria)criteria);
        if (isConsolidated) {
            ConsolidationUtil.buildConsolidatedQuery(query, ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.JULY.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.AUGUST.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.SEPTEMBER.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.OCTOBER.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.NOVEMBER.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.DECEMBER.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.JANUARY.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.FEBRUARY.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.MARCH.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.APRIL.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.MAY.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.JUNE.propertyName), ConsolidationUtil.sum(LaborPropertyConstants.AccountingPeriodProperties.YEAR_END.propertyName));
        }
        return query;
    }

    protected ReportQueryByCriteria getBalanceCountQuery(Map fieldValues, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        Criteria criteria = this.buildCriteriaFromMap(fieldValues, new LedgerBalance(), encumbranceBalanceTypes, noZeroAmounts);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalance.class, (Criteria)criteria);
        query.setAttributes(new String[]{"count(*)"});
        Collection<String> groupByList = ConsolidationUtil.buildGroupByCollection(new String[0]);
        groupByList.remove("subAccountNumber");
        groupByList.remove("financialSubObjectCode");
        groupByList.remove("financialObjectTypeCode");
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        return query;
    }

    protected Criteria buildCriteriaFromMap(Map fieldValues, LedgerBalance balance, List<String> encumbranceBalanceTypes, boolean noZeroAmounts) {
        String propertyValue;
        HashMap localFieldValues = new HashMap(fieldValues);
        Criteria criteria = new Criteria();
        String propertyName = "financialBalanceTypeCode";
        if (localFieldValues.containsKey(propertyName) && "EN".equals(propertyValue = (String)localFieldValues.get(propertyName))) {
            localFieldValues.remove("financialBalanceTypeCode");
            criteria.addIn("financialBalanceTypeCode", encumbranceBalanceTypes);
        }
        criteria.addAndCriteria(OJBUtility.buildCriteriaFromMap(localFieldValues, (Object)((Object)new LedgerBalance())));
        if (noZeroAmounts) {
            Criteria noZeroAmountsCriteria = new Criteria();
            noZeroAmountsCriteria.addEqualTo("month1Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month2Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month3Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month4Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month5Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month6Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month7Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month8Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month9Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month10Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month11Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month12Amount", (Object)0);
            noZeroAmountsCriteria.addEqualTo("month13Amount", (Object)0);
            noZeroAmountsCriteria.setNegative(true);
            criteria.addAndCriteria(noZeroAmountsCriteria);
        }
        return criteria;
    }

    @Override
    public List<LedgerBalance> findCurrentFunds(Map fieldValues) {
        LOG.debug("Start findCurrentFunds()");
        Iterator<Object[]> queryResults = this.findCurrentFundsRawData(fieldValues);
        ArrayList<LedgerBalance> currentFundsCollection = new ArrayList<LedgerBalance>();
        while (queryResults != null && queryResults.hasNext()) {
            currentFundsCollection.add(this.marshalFundsAsLedgerBalance(queryResults.next()));
        }
        return currentFundsCollection;
    }

    @Override
    public List<LedgerBalance> findEncumbranceFunds(Map fieldValues) {
        LOG.debug("Start findEncumbranceFunds()");
        Iterator<Object[]> queryResults = this.findEncumbranceFundsRawData(fieldValues);
        ArrayList<LedgerBalance> currentFundsCollection = new ArrayList<LedgerBalance>();
        while (queryResults != null && queryResults.hasNext()) {
            currentFundsCollection.add(this.marshalFundsAsLedgerBalance(queryResults.next()));
        }
        return currentFundsCollection;
    }

    @Override
    public List<EmployeeFunding> findCurrentEmployeeFunds(Map fieldValues) {
        LOG.debug("Start findCurrentEmployeeFunds()");
        Iterator<Object[]> queryResults = this.findCurrentFundsRawData(fieldValues);
        ArrayList<EmployeeFunding> currentFundsCollection = new ArrayList<EmployeeFunding>();
        while (queryResults != null && queryResults.hasNext()) {
            currentFundsCollection.add(this.marshalFundsAsEmployeeFunding(queryResults.next()));
        }
        return currentFundsCollection;
    }

    @Override
    public List<EmployeeFunding> findEncumbranceEmployeeFunds(Map fieldValues) {
        LOG.debug("Start findCurrentEmployeeFunds()");
        Iterator<Object[]> queryResults = this.findEncumbranceFundsRawData(fieldValues);
        ArrayList<EmployeeFunding> currentFundsCollection = new ArrayList<EmployeeFunding>();
        while (queryResults != null && queryResults.hasNext()) {
            currentFundsCollection.add(this.marshalFundsAsEmployeeFunding(queryResults.next()));
        }
        return currentFundsCollection;
    }

    @Override
    public List<LaborBalanceSummary> findBalanceSummary(Integer fiscalYear, Collection<String> balanceTypes) {
        LOG.debug("Start findBalanceSummary()");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        criteria.addIn("financialBalanceTypeCode", balanceTypes);
        Iterator<Object[]> queryResults = this.findBalanceSummaryRawData(criteria);
        ArrayList<LaborBalanceSummary> balanceSummaryCollection = new ArrayList<LaborBalanceSummary>();
        while (queryResults != null && queryResults.hasNext()) {
            balanceSummaryCollection.add(this.marshalFundsAsLaborBalanceSummary(queryResults.next()));
        }
        return balanceSummaryCollection;
    }

    protected Iterator<Object[]> findCurrentFundsRawData(Map fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new LedgerBalance()));
        criteria.addEqualTo("financialBalanceTypeCode", (Object)"AC");
        ArrayList<String> objectTypeCodes = new ArrayList<String>();
        objectTypeCodes.add("ES");
        objectTypeCodes.add("EX");
        criteria.addIn("financialObjectTypeCode", objectTypeCodes);
        return this.findFundsRawData(criteria);
    }

    protected Iterator<Object[]> findEncumbranceFundsRawData(Map fieldValues) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap((Map)fieldValues, (Object)((Object)new LedgerBalance()));
        criteria.addEqualTo("financialBalanceTypeCode", (Object)"IE");
        return this.findFundsRawData(criteria);
    }

    protected Iterator<Object[]> findFundsRawData(Criteria criteria) {
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalance.class, (Criteria)criteria);
        List<String> groupByList = this.getGroupByListForFundingInquiry();
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        List<String> getAttributeList = this.getAttributeListForFundingInquiry(false);
        String[] attributes = getAttributeList.toArray(new String[getAttributeList.size()]);
        query.setAttributes(attributes);
        OJBUtility.limitResultSize((Query)query);
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected Iterator<Object[]> findBalanceSummaryRawData(Criteria criteria) {
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalance.class, (Criteria)criteria);
        List<String> groupByList = this.getGroupByListForBalanceSummary();
        String[] groupBy = groupByList.toArray(new String[groupByList.size()]);
        query.addGroupBy(groupBy);
        List<String> getAttributeList = this.getAttributeListForBalanceSummary(false);
        String[] attributes = getAttributeList.toArray(new String[getAttributeList.size()]);
        query.setAttributes(attributes);
        query.addOrderByAscending(groupByList.get(0));
        return this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
    }

    protected LedgerBalance marshalFundsAsLedgerBalance(Object[] queryResult) {
        LedgerBalance ledgerBalance = new LedgerBalance();
        List<String> keyFields = this.getAttributeListForFundingInquiry(true);
        ObjectUtil.buildObject((Object)((Object)ledgerBalance), (Object[])queryResult, keyFields);
        return ledgerBalance;
    }

    protected EmployeeFunding marshalFundsAsEmployeeFunding(Object[] queryResult) {
        EmployeeFunding employeeFunding = new EmployeeFunding();
        List<String> keyFields = this.getAttributeListForFundingInquiry(true);
        ObjectUtil.buildObject((Object)((Object)employeeFunding), (Object[])queryResult, keyFields);
        return employeeFunding;
    }

    protected LaborBalanceSummary marshalFundsAsLaborBalanceSummary(Object[] queryResult) {
        return new LaborBalanceSummary(queryResult);
    }

    protected List<String> getGroupByListForFundingInquiry() {
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("universityFiscalYear");
        groupByList.add("chartOfAccountsCode");
        groupByList.add("accountNumber");
        groupByList.add("subAccountNumber");
        groupByList.add("financialObjectCode");
        groupByList.add("financialSubObjectCode");
        groupByList.add("financialObjectTypeCode");
        groupByList.add("positionNumber");
        groupByList.add("emplid");
        return groupByList;
    }

    protected List<String> getAttributeListForFundingInquiry(boolean isAttributeNameNeeded) {
        List<String> attributeList = this.getGroupByListForFundingInquiry();
        attributeList.add(ConsolidationUtil.wrapAttributeName("accountLineAnnualBalanceAmount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("financialBeginningBalanceLineAmount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("contractsGrantsBeginningBalanceAmount", isAttributeNameNeeded));
        return attributeList;
    }

    protected List<String> getGroupByListForBalanceSummary() {
        ArrayList<String> groupByList = new ArrayList<String>();
        groupByList.add("account.subFundGroup.fundGroupCode");
        return groupByList;
    }

    protected List<String> getAttributeListForBalanceSummary(boolean isAttributeNameNeeded) {
        List<String> attributeList = this.getGroupByListForBalanceSummary();
        attributeList.add(ConsolidationUtil.wrapAttributeName("accountLineAnnualBalanceAmount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("financialBeginningBalanceLineAmount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("contractsGrantsBeginningBalanceAmount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month1Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month2Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month3Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month4Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month5Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month6Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month7Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month8Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month9Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month10Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month11Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month12Amount", isAttributeNameNeeded));
        attributeList.add(ConsolidationUtil.wrapAttributeName("month13Amount", isAttributeNameNeeded));
        return attributeList;
    }

    @Override
    public List<List<String>> findAccountsInFundGroups(Integer fiscalYear, Map<String, String> fieldValues, List<String> subFundGroupCodes, List<String> fundGroupCodes) {
        Criteria criteria = OJBUtility.buildCriteriaFromMap(fieldValues, (Object)((Object)new LedgerBalanceForYearEndBalanceForward()));
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        if (subFundGroupCodes != null && !subFundGroupCodes.isEmpty()) {
            Criteria criteriaForSubFundGroup = new Criteria();
            String subFundGroupFieldName = "account.subFundGroupCode";
            criteriaForSubFundGroup.addIn(subFundGroupFieldName, subFundGroupCodes);
            if (fundGroupCodes != null && !fundGroupCodes.isEmpty()) {
                Criteria criteriaForFundGroup = new Criteria();
                String fundGroupFieldName = "account.subFundGroup.fundGroupCode";
                criteriaForFundGroup.addIn(fundGroupFieldName, fundGroupCodes);
                criteriaForSubFundGroup.addOrCriteria(criteriaForFundGroup);
            }
            criteria.addAndCriteria(criteriaForSubFundGroup);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalanceForYearEndBalanceForward.class, (Criteria)criteria);
        query.setAttributes(LaborConstants.ACCOUNT_FIELDS);
        query.setDistinct(true);
        Iterator accountIterator = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)query);
        ArrayList<List<String>> accounts = new ArrayList<List<String>>();
        while (accountIterator != null && accountIterator.hasNext()) {
            Object[] accountObject = (Object[])accountIterator.next();
            ArrayList<String> account = new ArrayList<String>();
            account.add(accountObject[0].toString());
            account.add(accountObject[1].toString());
            accounts.add(account);
        }
        return accounts;
    }

    @Override
    public Collection<LedgerBalance> findLedgerBalances(Map<String, List<String>> fieldValues, Map<String, List<String>> excludedFieldValues, Set<Integer> fiscalYears, List<String> balanceTypeList, List<String> positionObjectGroupCodes) {
        Criteria criteria = new Criteria();
        for (String fieldName : fieldValues.keySet()) {
            Criteria criteriaForIncludedFields = new Criteria();
            criteria.addIn(fieldName, (Collection)fieldValues.get(fieldName));
            criteria.addAndCriteria(criteriaForIncludedFields);
        }
        for (String fieldName : excludedFieldValues.keySet()) {
            Criteria criteriaForExcludedFields = new Criteria();
            criteria.addNotIn(fieldName, (Collection)excludedFieldValues.get(fieldName));
            criteria.addAndCriteria(criteriaForExcludedFields);
        }
        if (fiscalYears != null && !fiscalYears.isEmpty()) {
            Criteria criteriaForFiscalYear = new Criteria();
            criteriaForFiscalYear.addIn("universityFiscalYear", fiscalYears);
            criteria.addAndCriteria(criteriaForFiscalYear);
        }
        if (balanceTypeList != null && !balanceTypeList.isEmpty()) {
            Criteria criteriaForBalanceTypes = new Criteria();
            criteriaForBalanceTypes.addIn("financialBalanceTypeCode", balanceTypeList);
            criteria.addAndCriteria(criteriaForBalanceTypes);
        }
        if (positionObjectGroupCodes != null && !positionObjectGroupCodes.isEmpty()) {
            Criteria criteriaForLaborObjects = new Criteria();
            criteriaForLaborObjects.addIn("laborObject.positionObjectGroupCode", positionObjectGroupCodes);
            criteria.addAndCriteria(criteriaForLaborObjects);
        }
        QueryByCriteria query = QueryFactory.newQuery(LedgerBalance.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public void deleteLedgerBalancesPriorToYear(Integer fiscalYear, String chartOfAccountsCode) {
        LOG.debug("deleteLedgerBalancesPriorToYear() started");
        Criteria criteria = new Criteria();
        criteria.addLessThan((Object)"universityFiscalYear", (Object)fiscalYear);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        QueryByCriteria query = new QueryByCriteria(LedgerBalance.class, criteria);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)query);
    }

    public Integer findCountGreaterOrEqualThan(Integer year) {
        Criteria criteria = new Criteria();
        criteria.addGreaterOrEqualThan((Object)"universityFiscalYear", (Object)year);
        ReportQueryByCriteria query = QueryFactory.newReportQuery(LedgerBalance.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCount((Query)query);
    }
}

