/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.service;

import org.kuali.kfs.sys.batch.InitiateDirectory;

/**
 * The enterprise feeder is a component that feeds in origin entries from an external data source
 */
public interface EnterpriseFeederService extends InitiateDirectory {

    String DONE_FILE_SUFFIX = ".done";
    String DATA_FILE_SUFFIX = ".data";
    String RECON_FILE_SUFFIX = ".recon";

    /**
     * This method does the feeding
     *
     * @param processName          this merely identifies the process executing the feed. It will be used to build any
     *                             error messages, but computationally it should be ignored.
     * @param performNotifications whether notifications should be sent out
     */
    void feed(String processName, boolean performNotifications);

    /**
     * @return the staging directory name from which files are loaded.
     */
    String getDirectoryName();
}
