/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.integration.ld.LaborLedgerBenefitsCalculation;
import org.kuali.kfs.integration.ld.LaborLedgerBenefitsType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.FiscalYearBasedBusinessObject;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiPercent;

/**
 * Labor business object for Benefits Calculation.
 */
public class BenefitsCalculation extends PersistableBusinessObjectBase implements LaborLedgerBenefitsCalculation,
        MutableInactivatable, FiscalYearBasedBusinessObject {

    private Integer universityFiscalYear;
    private String chartOfAccountsCode;
    private String positionBenefitTypeCode;
    private KualiPercent positionFringeBenefitPercent;
    private String positionFringeBenefitObjectCode;
    private ObjectCode positionFringeBenefitObject;
    private Chart chartOfAccounts;
    private BenefitsType positionBenefitType;
    private transient SystemOptions universityFiscal;
    private boolean active;
    private LaborObject laborObject;
    private LaborBenefitRateCategory laborBenefitRateCategory;
    private String laborBenefitRateCategoryCode;
    private Account laborAccountOffset;
    private ObjectCode laborObjectCodeOffset;

    private String accountCodeOffset;
    private String objectCodeOffset;

    public BenefitsCalculation() {

    }

    @Override
    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    @Override
    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    @Override
    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    @Override
    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    @Override
    public String getPositionBenefitTypeCode() {
        return positionBenefitTypeCode;
    }

    @Override
    public void setPositionBenefitTypeCode(String positionBenefitTypeCode) {
        this.positionBenefitTypeCode = positionBenefitTypeCode;
    }

    @Override
    public KualiPercent getPositionFringeBenefitPercent() {
        return positionFringeBenefitPercent;
    }

    @Override
    public void setPositionFringeBenefitPercent(KualiPercent positionFringeBenefitPercent) {
        this.positionFringeBenefitPercent = positionFringeBenefitPercent;
    }

    @Override
    public String getPositionFringeBenefitObjectCode() {
        return positionFringeBenefitObjectCode;
    }

    @Override
    public void setPositionFringeBenefitObjectCode(String positionFringeBenefitObjectCode) {
        this.positionFringeBenefitObjectCode = positionFringeBenefitObjectCode;
    }

    @Override
    public ObjectCode getPositionFringeBenefitObject() {
        return positionFringeBenefitObject;
    }

    @Override
    @Deprecated
    public void setPositionFringeBenefitObject(ObjectCode positionFringeBenefitObject) {
        this.positionFringeBenefitObject = positionFringeBenefitObject;
    }

    @Override
    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Override
    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public BenefitsType getPositionBenefitType() {
        return positionBenefitType;
    }

    @Deprecated
    public void setPositionBenefitType(BenefitsType positionBenefitType) {
        this.positionBenefitType = positionBenefitType;
    }

    public LaborObject getLaborObject() {
        return laborObject;
    }

    @Deprecated
    public void setLaborObject(LaborObject laborObject) {
        this.laborObject = laborObject;
    }

    @Override
    public SystemOptions getUniversityFiscal() {
        return universityFiscal;
    }

    @Override
    public void setUniversityFiscal(SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    /**
     * This method (a hack by any other name...) returns a string so that an Labor Benefits Calculation can have a
     * link to view its own inquiry page after a look up
     *
     * @return the String "View Labor Benefits Calculation"
     */
    public String getLaborBenefitsCalculationViewer() {
        return "View Labor Benefits Calculation";
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public LaborLedgerBenefitsType getLaborLedgerBenefitsType() {
        return this.getPositionBenefitType();
    }

    @Override
    public void setLaborLedgerBenefitsType(LaborLedgerBenefitsType laborLedgerBenefitsType) {
        this.setPositionBenefitType((BenefitsType) laborLedgerBenefitsType);
    }

    public LaborBenefitRateCategory getLaborBenefitRateCategory() {
        return this.laborBenefitRateCategory;
    }

    public void setLaborBenefitRateCategory(LaborBenefitRateCategory laborBenefitRateCategory) {
        this.laborBenefitRateCategory = laborBenefitRateCategory;
    }

    public String getLaborBenefitRateCategoryCode() {
        return this.laborBenefitRateCategoryCode;
    }

    public void setLaborBenefitRateCategoryCode(String laborBenefitRateCategoryCode) {
        this.laborBenefitRateCategoryCode = laborBenefitRateCategoryCode;
    }

    public Account getLaborAccountOffset() {
        return laborAccountOffset;
    }

    public void setLaborAccountOffset(Account laborAccountOffset) {
        this.laborAccountOffset = laborAccountOffset;
    }

    public ObjectCode getLaborObjectCodeOffset() {
        return laborObjectCodeOffset;
    }

    public void setLaborObjectCodeOffset(ObjectCode laborObjectCodeOffset) {
        this.laborObjectCodeOffset = laborObjectCodeOffset;
    }

    public String getAccountCodeOffset() {
        return accountCodeOffset;
    }

    public void setAccountCodeOffset(String accountCodeOffset) {
        this.accountCodeOffset = accountCodeOffset;
    }

    public String getObjectCodeOffset() {
        return objectCodeOffset;
    }

    public void setObjectCodeOffset(String objectCodeOffset) {
        this.objectCodeOffset = objectCodeOffset;
    }

}
