/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.util;

import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;

import java.io.File;

public class FilteringLaborOriginEntryFileIterator extends LaborOriginEntryFileIterator {

    protected LaborOriginEntryFilter filter;

    /**
     * Constructs a LaborOriginEntryFilter When constructed with this method, the file handle will be automatically
     * closed when the end of origin entries has been reached (i.e. when hasNext() returns false)
     *
     * @param file the file
     */
    public FilteringLaborOriginEntryFileIterator(File file, LaborOriginEntryFilter filter) {
        super(file);
        this.filter = filter;
    }

    @Override
    protected void fetchNextEntry() {
        do {
            super.fetchNextEntry();
        }
        while (nextEntry != null && !filter.accept(nextEntry));
    }

    public interface LaborOriginEntryFilter {
        boolean accept(LaborOriginEntry originEntry);
    }
}
