/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.fp.document.web.struts.JournalVoucherForm;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.PositionData;
import org.kuali.kfs.sys.KFSConstants;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Struts Action Form for the Labor Ledger Journal Voucher. This class piggy backs on all of the functionality in the
 * FinancialSystemTransactionalDocumentActionBase but is necessary for this document type. The Journal Voucher is
 * unique in that it defines several fields that aren't typically used by the other financial transaction processing
 * eDocs (i.e. external system fields, object type override, credit and debit amounts).
 */
public class LaborJournalVoucherAction extends org.kuali.kfs.fp.document.web.struts.JournalVoucherAction {

    @Override
    public ActionForward performLookup(
            final ActionMapping mapping, final ActionForm form, final HttpServletRequest request,
            final HttpServletResponse response) throws Exception {
        // parse out the business object name from our methodToCall parameter
        final String fullParameter = (String) request.getAttribute(KFSConstants.METHOD_TO_CALL_ATTRIBUTE);
        final String boClassName = StringUtils.substringBetween(fullParameter, KFSConstants.METHOD_TO_CALL_BOPARM_LEFT_DEL,
                KFSConstants.METHOD_TO_CALL_BOPARM_RIGHT_DEL);

        if (StringUtils.equals(boClassName, LaborLedgerPendingEntry.class.getName())) {
            String path = super.performLookup(mapping, form, request, response).getPath();
            path = path.replaceFirst(KFSConstants.LOOKUP_ACTION, LaborConstants.LONG_ROW_TABLE_INQUIRY_ACTION);
            return new ActionForward(path, true);
        } else if (StringUtils.equals(boClassName, PositionData.class.getName())) {
            String path = super.performLookup(mapping, form, request, response).getPath();
            path = path.replaceFirst(KFSConstants.LOOKUP_ACTION, KFSConstants.GL_MODIFIED_INQUIRY_ACTION);
            return new ActionForward(path, true);
        } else {
            return super.performLookup(mapping, form, request, response);
        }
    }

    /**
     * Labor JV allows reference fields on all encumbrance types. So only want to give message if a change is being
     * made from a encumbrance balance type to a nor (or vice-versa).
     */
    @Override
    protected int determineBalanceTypeEncumbranceChangeMode(final JournalVoucherForm journalVoucherForm) throws Exception {
        int balanceTypeExternalEncumbranceChangeMode = NO_MODE_CHANGE;

        // retrieve fully populated balance type instances
        final BalanceType origBalType = getPopulatedBalanceTypeInstance(journalVoucherForm.getOriginalBalanceType());
        final BalanceType newBalType = journalVoucherForm.getSelectedBalanceType();

        // then deal with external encumbrance changes
        if (origBalType.isFinBalanceTypeEncumIndicator() && !newBalType.isFinBalanceTypeEncumIndicator()) {
            balanceTypeExternalEncumbranceChangeMode = EXT_ENCUMB_TO_NON_EXT_ENCUMB;
        } else if (!origBalType.isFinBalanceTypeEncumIndicator() && newBalType.isFinBalanceTypeEncumIndicator()) {
            balanceTypeExternalEncumbranceChangeMode = NON_EXT_ENCUMB_TO_EXT_ENCUMB;
        }

        return balanceTypeExternalEncumbranceChangeMode;
    }

}
