/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.integration.ld.LaborLedgerBenefitsType;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

/**
 * Labor business object for Benefits Type
 */
public class BenefitsType extends PersistableBusinessObjectBase implements LaborLedgerBenefitsType,
        MutableInactivatable {

    private String positionBenefitTypeCode;
    private String positionBenefitTypeDescription;
    private boolean positionBenefitRetirementIndicator;
    private boolean active;

    public BenefitsType() {

    }

    @Override
    public String getPositionBenefitTypeCode() {
        return positionBenefitTypeCode;
    }

    @Override
    public void setPositionBenefitTypeCode(final String positionBenefitTypeCode) {
        this.positionBenefitTypeCode = positionBenefitTypeCode;
    }

    @Override
    public String getPositionBenefitTypeDescription() {
        return positionBenefitTypeDescription;
    }

    @Override
    public void setPositionBenefitTypeDescription(final String positionBenefitTypeDescription) {
        this.positionBenefitTypeDescription = positionBenefitTypeDescription;
    }

    @Override
    public boolean isPositionBenefitRetirementIndicator() {
        return positionBenefitRetirementIndicator;
    }

    @Override
    public void setPositionBenefitRetirementIndicator(final boolean positionBenefitRetirementIndicator) {
        this.positionBenefitRetirementIndicator = positionBenefitRetirementIndicator;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(final boolean active) {
        this.active = active;
    }

}
