/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject.inquiry;

import org.kuali.kfs.gl.Constant;
import org.kuali.kfs.gl.businessobject.lookup.BusinessObjectFieldConverter;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.KFSConstants;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This class is used to generate the URL for the user-defined attributes for the July1 Position Funds screen. It
 * extends the KualiInquirableImpl class, so it covers both the default implementation and customized implementation.
 */
public class July1PositionFundingInquirableImpl extends AbstractLaborInquirableImpl {

    @Override
    protected List buildUserDefinedAttributeKeyList() {
        return new ArrayList<String>();
    }

    @Override
    protected Map getUserDefinedAttributeMap() {
        return new HashMap();
    }

    @Override
    protected String getAttributeName(final String attributeName) {
        return attributeName;
    }

    @Override
    protected Object getKeyValue(final String keyName, Object keyValue) {
        if (isExclusiveField(keyName, keyValue)) {
            keyValue = Constant.EMPTY_STRING;
        }
        return keyValue;
    }

    @Override
    protected String getKeyName(String keyName) {
        keyName = BusinessObjectFieldConverter.convertToTransactionPropertyName(keyName);
        return keyName;
    }

    @Override
    protected String getLookupableImplAttributeName() {
        return "july1PositionFundingLookupable";
    }

    @Override
    protected String getBaseUrl() {
        return KFSConstants.GL_MODIFIED_INQUIRY_ACTION;
    }

    @Override
    protected Class getInquiryBusinessObjectClass(final String attributeName) {
        return LedgerBalance.class;
    }
}
