/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.gl.businessobject.TransientBalanceInquiryAttributes;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.math.BigDecimal;

/**
 * Labor business object for July 1 Position Funding
 */
public class July1PositionFunding extends LedgerBalance {

    private KualiDecimal july1BudgetAmount;
    private BigDecimal july1BudgetFteQuantity;
    private BigDecimal july1BudgetTimePercent;
    private String personName;
    private TransientBalanceInquiryAttributes dummyBusinessObject;

    public July1PositionFunding() {

    }

    public KualiDecimal getJuly1BudgetAmount() {
        return july1BudgetAmount;
    }

    public void setJuly1BudgetAmount(final KualiDecimal july1BudgetAmount) {
        this.july1BudgetAmount = july1BudgetAmount;
    }

    public BigDecimal getJuly1BudgetFteQuantity() {
        return july1BudgetFteQuantity;
    }

    public void setJuly1BudgetFteQuantity(final BigDecimal july1BudgetFteQuantity) {
        this.july1BudgetFteQuantity = july1BudgetFteQuantity;
    }

    public BigDecimal getJuly1BudgetTimePercent() {
        return july1BudgetTimePercent;
    }

    public void setJuly1BudgetTimePercent(final BigDecimal july1BudgetTimePercent) {
        this.july1BudgetTimePercent = july1BudgetTimePercent;
    }

    @Override
    public TransientBalanceInquiryAttributes getDummyBusinessObject() {
        return dummyBusinessObject;
    }

    @Override
    public void setDummyBusinessObject(final TransientBalanceInquiryAttributes dummyBusinessObject) {
        this.dummyBusinessObject = dummyBusinessObject;
    }

    public String getName() {
        /*
         * KFSCNTRB-1344
         * Replace the logic that uses PersonService with the following one that uses IdentityService, since the
         * former is a lot slower.
         */
        final String name = SpringContext.getBean(FinancialSystemUserService.class).getPersonNameByEmployeeId(getEmplid());
        if (StringUtils.isNotEmpty(name)) {
            return name;
        }
        return LaborConstants.BalanceInquiries.UnknownPersonName;
    }

    public void setName(final String personName) {
        this.personName = personName;
    }
}
