/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.LaborKeyConstants;
import org.kuali.kfs.module.ld.businessobject.LateAdjustment;
import org.kuali.kfs.module.ld.document.LateAdjustable;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LateAdjustmentValidation extends GenericValidation {

    private static final Logger LOG = LogManager.getLogger();

    @Override
    public boolean validate(final AttributedDocumentEvent event) {
        final int numBlankFields = lateAdjustmentBlankFieldsCheck((LateAdjustable) event.getDocument());
        LOG.debug("numBlankFields: {}", numBlankFields);

        // if Late Adjustment tab is partially filled out
        if (numBlankFields > 0 && numBlankFields < LaborConstants.LateAdjustment.NUM_LATE_ADJUST_FIELDS) {
            GlobalVariables.getMessageMap().putErrorForSectionId(LaborKeyConstants.LateAdjustment.ERROR_LATE_ADJUST_KEY,
                    LaborKeyConstants.LateAdjustment.ERROR_LATE_ADJUST_FIELDS_REQ);
            return false;
        }

        return true;
    }

    public int lateAdjustmentBlankFieldsCheck(final LateAdjustable document) {
        int blankFieldCount = 0;

        final LateAdjustment ecTab = document.getLateAdjustment();

        if (StringUtils.isBlank(ecTab.getExpenditureDescription())) {
            blankFieldCount++;
        }

        if (StringUtils.isBlank(ecTab.getExpenditureProjectBenefit())) {
            blankFieldCount++;
        }

        if (StringUtils.isBlank(ecTab.getLateAdjustmentDescription())) {
            blankFieldCount++;
        }

        if (StringUtils.isBlank(ecTab.getLateAdjustmentReason())) {
            blankFieldCount++;
        }

        return blankFieldCount;
    }
}
