/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.report;

import org.kuali.kfs.sys.service.impl.ReportWriterTextServiceImpl;

public class LaborEncumbranceReportWriterService extends ReportWriterTextServiceImpl {

    private boolean modeError;

    public void writeErrorLine(final String message) {
        if (!modeError) {
            modeError = true;

            if (!(page == initialPageNumber && line == INITIAL_LINE_NUMBER + 2)) {
                pageBreak();
            }

            writeFormattedMessageLine("*********************************************************************************************************************************");
            writeFormattedMessageLine("*********************************************************************************************************************************");
            writeFormattedMessageLine("*******************" + " E R R O R   M E S S A G E S " + "*******************");
            writeFormattedMessageLine("*********************************************************************************************************************************");
            writeFormattedMessageLine("*********************************************************************************************************************************");
        }

        for (final String line : message.split("\n")) {
            writeFormattedMessageLine(line);
        }

        writeNewLines(1);
    }
}
