/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.service.impl;

import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.dataaccess.LaborBaseFundsDao;
import org.kuali.kfs.module.ld.service.LaborBaseFundsService;
import org.kuali.kfs.module.ld.service.LaborCalculatedSalaryFoundationTrackerService;

import java.util.List;
import java.util.Map;

/**
 * This class provides its clients with access to labor base fund entries in the backend data store.
 *
 * @see org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds
 */
public class LaborBaseFundsServiceImpl implements LaborBaseFundsService {

    private LaborBaseFundsDao laborBaseFundsDao;
    private LaborCalculatedSalaryFoundationTrackerService laborCalculatedSalaryFoundationTrackerService;

    @Override
    public List<AccountStatusBaseFunds> findLaborBaseFunds(final Map fieldValues, final boolean isConsolidated) {
        return laborBaseFundsDao.findLaborBaseFunds(fieldValues, isConsolidated);
    }

    @Override
    public List<AccountStatusBaseFunds> findAccountStatusBaseFundsWithCSFTracker(
            final Map fieldValues,
            final boolean isConsolidated) {
        final List<AccountStatusBaseFunds> baseFundsCollection = findLaborBaseFunds(fieldValues, isConsolidated);
        final List<AccountStatusBaseFunds> CSFTrackersCollection = laborCalculatedSalaryFoundationTrackerService
                .findCSFTrackersAsAccountStatusBaseFunds(fieldValues, isConsolidated);

        for (final AccountStatusBaseFunds CSFTracker : CSFTrackersCollection) {
            if (baseFundsCollection.contains(CSFTracker)) {
                final int index = baseFundsCollection.indexOf(CSFTracker);
                baseFundsCollection.get(index).setCsfAmount(CSFTracker.getCsfAmount());
            } else {
                baseFundsCollection.add(CSFTracker);
            }
        }
        return baseFundsCollection;
    }

    public void setLaborBaseFundsDao(final LaborBaseFundsDao laborBaseFundsDao) {
        this.laborBaseFundsDao = laborBaseFundsDao;
    }

    public void setLaborCalculatedSalaryFoundationTrackerService(
            final LaborCalculatedSalaryFoundationTrackerService laborCalculatedSalaryFoundationTrackerService) {
        this.laborCalculatedSalaryFoundationTrackerService = laborCalculatedSalaryFoundationTrackerService;
    }
}
