/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.batch.service.LaborNightlyOutService;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.module.ld.util.LaborOriginEntryForTesting;
import org.kuali.kfs.module.ld.util.PendingLedgerEntryForTesting;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.batch.BatchDirectoryHelper;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborNightlyOutServiceIntegTest
extends KualiIntegTestBase {
    private Properties properties;
    private Map<String, Object> fieldValues;
    private BusinessObjectService businessObjectService;
    private LaborNightlyOutService laborNightlyOutService;
    private File nightlyOutputFile;
    private File nightlyOutputDoneFile;
    private BatchDirectoryHelper batchDirectoryHelper;

    public void setUp() throws Exception {
        super.setUp();
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborNightlyOutService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        String fieldNames = this.properties.getProperty("fieldNames");
        String documentFieldNames = this.properties.getProperty("documentFieldNames");
        String deliminator = this.properties.getProperty("deliminator");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.laborNightlyOutService = (LaborNightlyOutService)SpringContext.getBean(LaborNightlyOutService.class);
        int numberOfDocuments = Integer.parseInt(this.properties.getProperty("document.numOfData"));
        List inputDataList = TestDataPreparator.buildTestDataList(DocumentHeader.class, (Properties)this.properties, (String)"document.testData", (String)documentFieldNames, (String)deliminator, (int)numberOfDocuments);
        this.businessObjectService.save(inputDataList);
        LaborLedgerPendingEntry cleanup = new LaborLedgerPendingEntry();
        ObjectUtil.populateBusinessObject((Object)cleanup, (Properties)this.properties, (String)"dataCleanup", (String)fieldNames, (String)deliminator);
        this.fieldValues = ObjectUtil.buildPropertyMap((Object)cleanup, Arrays.asList(StringUtils.split((String)fieldNames, (String)deliminator)));
        this.fieldValues.remove("financialDocumentApprovedCode");
        this.businessObjectService.deleteMatching(LaborLedgerPendingEntry.class, this.fieldValues);
        this.batchDirectoryHelper = new BatchDirectoryHelper("ld", "originEntry");
        this.batchDirectoryHelper.createBatchDirectory();
        String nightlyOutputFileName = this.batchDirectoryHelper.getBatchFileDirectoryName() + File.separator + "ld_labentry_kfs.data";
        String nightlyOutputDoneFileName = this.batchDirectoryHelper.getBatchFileDirectoryName() + File.separator + "ld_labentry_kfs.done";
        this.nightlyOutputFile = new File(nightlyOutputFileName);
        this.nightlyOutputDoneFile = new File(nightlyOutputDoneFileName);
    }

    public void testCopyApprovedPendingLedgerEntries() {
        String testTarget = "copyApprovedPendingLedgerEntries.";
        int numberOfTestData = Integer.parseInt(this.properties.getProperty("copyApprovedPendingLedgerEntries.numOfData"));
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"copyApprovedPendingLedgerEntries.testData", (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        this.laborNightlyOutService.copyApprovedPendingLedgerEntries();
        int expectedNumOfData = Integer.parseInt(this.properties.getProperty("copyApprovedPendingLedgerEntries.expectedNumOfData"));
        List expectedDataList = TestDataPreparator.buildExpectedValueList(LaborOriginEntryForTesting.class, (Properties)this.properties, (String)"copyApprovedPendingLedgerEntries.expected", (int)expectedNumOfData);
        LaborOriginEntryFileIterator originEntries = new LaborOriginEntryFileIterator(this.nightlyOutputFile);
        int sizeOfOriginEntries = 0;
        while (originEntries.hasNext()) {
            LaborOriginEntryForTesting originEntryForTesting = new LaborOriginEntryForTesting();
            ObjectUtil.buildObject((Object)((Object)originEntryForTesting), originEntries.next());
            ++sizeOfOriginEntries;
            LaborNightlyOutServiceIntegTest.assertTrue((String)"Cannot find the expected entry", (boolean)expectedDataList.contains((Object)originEntryForTesting));
        }
        LaborNightlyOutServiceIntegTest.assertEquals((int)expectedNumOfData, (int)sizeOfOriginEntries);
    }

    public void testCopyPendingLedgerEntries() {
        String testTarget = "copyPendingLedgerEntries.";
        int numberOfTestData = Integer.parseInt(this.properties.getProperty("copyPendingLedgerEntries.numOfData"));
        int expectedNumOfData = Integer.parseInt(this.properties.getProperty("copyPendingLedgerEntries.expectedNumOfData"));
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"copyPendingLedgerEntries.testData", (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        this.laborNightlyOutService.copyApprovedPendingLedgerEntries();
        List expectedDataList = TestDataPreparator.buildExpectedValueList(LaborOriginEntryForTesting.class, (Properties)this.properties, (String)"copyPendingLedgerEntries.expected", (int)expectedNumOfData);
        LaborOriginEntryFileIterator originEntries = new LaborOriginEntryFileIterator(this.nightlyOutputFile);
        int sizeOfOriginEntries = 0;
        while (originEntries.hasNext()) {
            LaborOriginEntryForTesting originEntryForTesting = new LaborOriginEntryForTesting();
            ObjectUtil.buildObject((Object)((Object)originEntryForTesting), originEntries.next());
            ++sizeOfOriginEntries;
            LaborNightlyOutServiceIntegTest.assertTrue((String)"Cannot find the expected entry", (boolean)expectedDataList.contains((Object)originEntryForTesting));
        }
        LaborNightlyOutServiceIntegTest.assertEquals((int)expectedNumOfData, (int)sizeOfOriginEntries);
    }

    public void testDeleteCopiedPendingLedgerEntries() {
        String testTarget = "deleteCopiedPendingLedgerEntries.";
        int numberOfTestData = Integer.parseInt(this.properties.getProperty("deleteCopiedPendingLedgerEntries.numOfData"));
        int expectedNumOfData = Integer.parseInt(this.properties.getProperty("deleteCopiedPendingLedgerEntries.expectedNumOfData"));
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"deleteCopiedPendingLedgerEntries.testData", (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        this.laborNightlyOutService.deleteCopiedPendingLedgerEntries();
        int sizeOfPendingEntries = this.businessObjectService.countMatching(LaborLedgerPendingEntry.class, this.fieldValues);
        LaborNightlyOutServiceIntegTest.assertEquals((int)expectedNumOfData, (int)sizeOfPendingEntries);
    }

    public void testDeletePendingLedgerEntries() {
        String testTarget = "deletePendingLedgerEntries.";
        int numberOfTestData = Integer.parseInt(this.properties.getProperty("deletePendingLedgerEntries.numOfData"));
        int expectedNumOfData = Integer.parseInt(this.properties.getProperty("deletePendingLedgerEntries.expectedNumOfData"));
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"deletePendingLedgerEntries.testData", (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        this.laborNightlyOutService.deleteCopiedPendingLedgerEntries();
        List expectedDataList = TestDataPreparator.buildExpectedValueList(PendingLedgerEntryForTesting.class, (Properties)this.properties, (String)"deletePendingLedgerEntries.expected", (int)expectedNumOfData);
        Collection pendingEntries = this.businessObjectService.findMatching(LaborLedgerPendingEntry.class, this.fieldValues);
        for (LaborLedgerPendingEntry pendingEntry : pendingEntries) {
            PendingLedgerEntryForTesting pendingEntryForTesting = new PendingLedgerEntryForTesting();
            ObjectUtil.buildObject((Object)((Object)pendingEntryForTesting), (Object)pendingEntry);
            LaborNightlyOutServiceIntegTest.assertTrue((String)"Cannot find the expected entry", (boolean)expectedDataList.contains((Object)pendingEntryForTesting));
        }
        LaborNightlyOutServiceIntegTest.assertEquals((int)expectedNumOfData, (int)pendingEntries.size());
    }

    protected void tearDown() throws Exception {
        if (this.nightlyOutputFile != null && this.nightlyOutputFile.exists() && this.nightlyOutputFile.isFile()) {
            this.nightlyOutputFile.delete();
        }
        if (this.nightlyOutputDoneFile != null && this.nightlyOutputDoneFile.exists() && this.nightlyOutputDoneFile.isFile()) {
            this.nightlyOutputDoneFile.delete();
        }
        this.batchDirectoryHelper.removeBatchDirectory();
        super.tearDown();
    }
}

