/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.util.HashMap;
import org.kuali.kfs.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.kfs.gl.batch.service.impl.BalancingServiceBaseImpl;
import org.kuali.kfs.gl.batch.service.impl.BalancingServiceImplIntegTestBase;
import org.kuali.kfs.gl.dataaccess.LedgerBalancingDao;
import org.kuali.kfs.gl.dataaccess.LedgerEntryHistoryBalancingDao;
import org.kuali.kfs.kns.bo.Step;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.batch.LaborBalancingStep;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceHistory;
import org.kuali.kfs.module.ld.businessobject.LaborEntryHistory;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.batch.BatchSpringContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborBalancingServiceImplIntegTest
extends BalancingServiceImplIntegTestBase {
    private boolean batchFileDirectoryCreated;

    protected void setUp() throws Exception {
        this.balancingService = (BalancingServiceBaseImpl)IntegTestUtils.getUnproxiedService((String)"laborBalancingService");
        this.ledgerEntryHistoryBalancingDao = (LedgerEntryHistoryBalancingDao)GlobalResourceLoader.getService((String)"laborLedgerEntryHistoryDao");
        this.ledgerBalancingDao = (LedgerBalancingDao)GlobalResourceLoader.getService((String)"laborBalancingDao");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        HashMap fieldValues = new HashMap();
        this.businessObjectService.deleteMatching(LedgerEntry.class, fieldValues);
        this.businessObjectService.deleteMatching(LedgerBalance.class, fieldValues);
        this.businessObjectService.deleteMatching(LaborEntryHistory.class, fieldValues);
        this.businessObjectService.deleteMatching(LaborBalanceHistory.class, fieldValues);
        IntegTestUtils.setSystemParameter(LaborBalancingStep.class, (String)"PAST_FISCAL_YEARS", (String)"0");
        File batchFileDirectory = new File(this.getBatchFileDirectoryName());
        if (!batchFileDirectory.exists()) {
            batchFileDirectory.mkdir();
            this.batchFileDirectoryCreated = true;
        }
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.batchFileDirectoryCreated) {
            File batchFileDirectory = new File(this.getBatchFileDirectoryName());
            for (File f : batchFileDirectory.listFiles()) {
                f.delete();
            }
            batchFileDirectory.delete();
            this.batchFileDirectoryCreated = false;
        }
        super.tearDown();
    }

    public void testRunBalancingPopulateData() {
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getLedgerEntryBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getLedgerBalanceBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getHistoryCount(null, LaborEntryHistory.class));
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getHistoryCount(null, LaborBalanceHistory.class));
        this.postTestCaseEntries(this.INPUT_TRANSACTIONS);
        LaborBalancingServiceImplIntegTest.assertEquals((int)12, (int)this.getLedgerEntryBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)3, (int)this.getLedgerBalanceBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertTrue((boolean)this.balancingService.runBalancing());
        LaborBalancingServiceImplIntegTest.assertEquals((int)12, (int)this.ledgerEntryHistoryBalancingDao.findSumRowCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)10, (int)this.getHistoryCount(null, LaborEntryHistory.class));
        LaborBalancingServiceImplIntegTest.assertEquals((int)3, (int)this.getHistoryCount(null, LaborBalanceHistory.class));
        this.assertCompareHistorySuccess();
    }

    public void testRunBalancingDeleteObsoleteUniversityFiscalYearData() {
        this.postTestCaseEntries(this.INPUT_TRANSACTIONS);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Populate should have copied some data", (0 != this.ledgerBalancingDao.populateLedgerEntryHistory(this.obsoleteUniversityFiscalYear) ? 1 : 0) != 0);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Populate should have copied some data", (0 != this.ledgerBalancingDao.populateLedgerBalanceHistory(this.obsoleteUniversityFiscalYear) ? 1 : 0) != 0);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Found no LaborEntryHistory", (0 != this.getHistoryCount(this.obsoleteUniversityFiscalYear, LaborEntryHistory.class) ? 1 : 0) != 0);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Found no LaborBalanceHistory", (0 != this.getHistoryCount(this.obsoleteUniversityFiscalYear, LaborBalanceHistory.class) ? 1 : 0) != 0);
        LaborBalancingServiceImplIntegTest.assertTrue((boolean)this.balancingService.runBalancing());
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getHistoryCount(this.obsoleteUniversityFiscalYear, LaborEntryHistory.class));
        LaborBalancingServiceImplIntegTest.assertEquals((int)0, (int)this.getHistoryCount(this.obsoleteUniversityFiscalYear, LaborBalanceHistory.class));
    }

    public void testRunBalancingHistoryUpdate() {
        this.postTestCaseEntries(this.INPUT_TRANSACTIONS);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Populate should have copied some data", (0 != this.ledgerBalancingDao.populateLedgerEntryHistory(this.obsoleteUniversityFiscalYear) ? 1 : 0) != 0);
        LaborBalancingServiceImplIntegTest.assertTrue((String)"Populate should have copied some data", (0 != this.ledgerBalancingDao.populateLedgerBalanceHistory(this.obsoleteUniversityFiscalYear) ? 1 : 0) != 0);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LaborBalancingServiceImplIntegTest.fail((String)"No reason that this job should have gotten interrupted.");
        }
        this.postTestCaseEntries(this.INPUT_TRANSACTIONS);
        LaborBalancingServiceImplIntegTest.assertEquals((int)24, (int)this.getLedgerEntryBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)3, (int)this.getLedgerBalanceBalancingDao().findCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertTrue((boolean)this.balancingService.runBalancing());
        LaborBalancingServiceImplIntegTest.assertEquals((int)24, (int)this.ledgerEntryHistoryBalancingDao.findSumRowCountGreaterOrEqualThan(this.startUniversityFiscalYear));
        LaborBalancingServiceImplIntegTest.assertEquals((int)10, (int)this.getHistoryCount(null, LaborEntryHistory.class));
        LaborBalancingServiceImplIntegTest.assertEquals((int)3, (int)this.getHistoryCount(null, LaborBalanceHistory.class));
        this.assertCompareHistorySuccess();
    }

    protected void postTestCaseEntries(String[] inputTransactions) {
        IntegTestUtils.writeFile((String)(this.getBatchFileDirectoryName() + File.separator + "ld_sortpost.data"), (String[])inputTransactions);
        try {
            Step laborPosterStep = BatchSpringContext.getStep((String)"laborPosterStep");
            LaborBalancingServiceImplIntegTest.assertTrue((String)"laborPosterStep should have succeeded", (boolean)laborPosterStep.execute(((Object)((Object)this)).getClass().getName(), this.dateTimeService.getCurrentDate()));
            Step laborFileRenameStep = BatchSpringContext.getStep((String)"laborFileRenameStep");
            LaborBalancingServiceImplIntegTest.assertTrue((String)"laborFileRenameStep should have succeeded", (boolean)laborFileRenameStep.execute(((Object)((Object)this)).getClass().getName(), this.dateTimeService.getCurrentDate()));
        }
        catch (InterruptedException e) {
            LaborBalancingServiceImplIntegTest.assertTrue((String)("laborPosterStep or laborFileRenameStep failed: " + e.getMessage()), (boolean)true);
        }
    }

    protected String[] getInputTransactions() {
        return new String[]{"BL1031400-----    ---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90D2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----    ---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47D2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----    ---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77D2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----    ---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5760---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5772---A2EX05BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5625---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90D2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5760---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47D2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5772---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77D2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5625---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90C2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5760---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47C2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5772---A2EX06BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77C2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5625---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5625---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       619.90C2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5760---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5760---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       276.47C2009-02-05                                                                     0.00     200906000000000010                                                      ", "BL1031400-----5772---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77C2009-02-05                                                                     0.00     200905000000000010                                                      ", "BL1031400-----5772---A2EX08BT  01LP2837509     88888------------------TEST DESCRIPTION                                       448.77C2009-02-05                                                                     0.00     200906000000000010                                                      "};
    }
}

