/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ld.businessobject.EmployeeFunding;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.dataaccess.LaborLedgerBalanceDao;
import org.kuali.kfs.module.ld.service.impl.LaborLedgerBalanceServiceImpl;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.TestDataPreparator;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
class LaborLedgerBalanceServiceImplTest {
    private Properties properties;
    private String transactionFieldNames;
    private String fundingFieldNames;
    private String deliminator;
    private LaborLedgerBalanceServiceImpl laborLedgerBalanceServiceImpl;
    @Mock
    private LaborLedgerBalanceDao laborLedgerBalanceDaoMck;

    LaborLedgerBalanceServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerBalanceService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.transactionFieldNames = this.properties.getProperty("transactionFieldNames");
        this.fundingFieldNames = this.properties.getProperty("fundingFieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.laborLedgerBalanceServiceImpl = new LaborLedgerBalanceServiceImpl();
        this.laborLedgerBalanceServiceImpl.setLaborLedgerBalanceDao(this.laborLedgerBalanceDaoMck);
    }

    @Test
    void findLedgerBalance_Found() {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.parseInt(this.properties.getProperty("findLedgerBalance.numOfLedgerBalance"));
        int numberOfTransaction = Integer.parseInt(this.properties.getProperty("findLedgerBalance.numOfTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)"findLedgerBalance.ledgerBalance", (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"findLedgerBalance.transaction", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            Assertions.assertNotNull((Object)this.laborLedgerBalanceServiceImpl.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    @Test
    void findLedgerBalance_NotFound() {
        String testTarget = "findLedgerBalance.";
        int numberOfLedgerBalance = Integer.parseInt(this.properties.getProperty("findLedgerBalance.numOfLedgerBalance"));
        int numberOfTransaction = Integer.parseInt(this.properties.getProperty("findLedgerBalance.numOfNotFoundTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)"findLedgerBalance.ledgerBalance", (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"findLedgerBalance.notFoundTransaction", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            Assertions.assertNull((Object)this.laborLedgerBalanceServiceImpl.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction));
        }
    }

    @Test
    void addLedgerBalance_New() {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.parseInt(this.properties.getProperty("addLedgerBalance.numOfLedgerBalance"));
        int numberOfTransaction = Integer.parseInt(this.properties.getProperty("addLedgerBalance.numOfNewTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)"addLedgerBalance.ledgerBalance", (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"addLedgerBalance.newTransaction", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceServiceImpl.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        int expectedNumberOfBalances = numberOfLedgerBalance + numberOfTransaction;
        Assertions.assertEquals((int)expectedNumberOfBalances, (int)ledgerBalanceList.size());
    }

    @Test
    void addLedgerBalance_Existing() {
        String testTarget = "addLedgerBalance.";
        int numberOfLedgerBalance = Integer.parseInt(this.properties.getProperty("addLedgerBalance.numOfLedgerBalance"));
        int numberOfTransaction = Integer.parseInt(this.properties.getProperty("addLedgerBalance.numOfExistingTransaction"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)"addLedgerBalance.ledgerBalance", (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"addLedgerBalance.existingTransaction", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            this.laborLedgerBalanceServiceImpl.addLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
        }
        Assertions.assertEquals((int)numberOfLedgerBalance, (int)ledgerBalanceList.size());
    }

    @Test
    void updateLedgerBalance() {
        String testTarget = "updateLedgerBalance.";
        int numberOfLedgerBalance = Integer.parseInt(this.properties.getProperty("updateLedgerBalance.numOfLedgerBalance"));
        int numberOfTransaction = Integer.parseInt(this.properties.getProperty("updateLedgerBalance.numOfTransaction"));
        int numberOfExpected = Integer.parseInt(this.properties.getProperty("updateLedgerBalance.numOfExpected"));
        List ledgerBalanceList = TestDataPreparator.buildTestDataList(LedgerBalance.class, (Properties)this.properties, (String)"updateLedgerBalance.ledgerBalance", (int)numberOfLedgerBalance);
        List transactionList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"updateLedgerBalance.transaction", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfTransaction);
        for (LaborOriginEntry transaction : transactionList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceServiceImpl.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)transaction);
            if (ledgerBalance == null) continue;
            this.laborLedgerBalanceServiceImpl.updateLedgerBalance(ledgerBalance, (LaborTransaction)transaction);
        }
        List expectedList = TestDataPreparator.buildTestDataList(LaborOriginEntry.class, (Properties)this.properties, (String)"updateLedgerBalance.expected", (String)this.transactionFieldNames, (String)this.deliminator, (int)numberOfExpected);
        for (LaborOriginEntry expected : expectedList) {
            LedgerBalance ledgerBalance = this.laborLedgerBalanceServiceImpl.findLedgerBalance((Collection)ledgerBalanceList, (LaborTransaction)expected);
            Assertions.assertNotNull((Object)ledgerBalance);
            Assertions.assertEquals((Object)expected.getTransactionLedgerEntryAmount(), (Object)ledgerBalance.getMonth1Amount());
        }
    }

    @Test
    void findEmployeeFunding_noCurrentFunds() {
        String testEncumberance = "encumbrance.";
        int numberOfEncumbrance = Integer.parseInt(this.properties.getProperty("encumbrance.numOfExpected"));
        HashMap<String, String> dummyArg = new HashMap<String, String>();
        dummyArg.put("testData", "testData");
        ArrayList currentFundsTestData = new ArrayList();
        List currentEncumberancesTestData = TestDataPreparator.buildTestDataList(EmployeeFunding.class, (Properties)this.properties, (String)"encumbrance.funding", (String)this.fundingFieldNames, (String)this.deliminator, (int)numberOfEncumbrance);
        Mockito.when((Object)this.laborLedgerBalanceDaoMck.findCurrentEmployeeFunds(dummyArg)).thenReturn(currentFundsTestData);
        Mockito.when((Object)this.laborLedgerBalanceDaoMck.findEncumbranceEmployeeFunds(dummyArg)).thenReturn((Object)currentEncumberancesTestData);
        List expectedValues = this.laborLedgerBalanceServiceImpl.findEmployeeFunding(dummyArg, false);
        for (EmployeeFunding funding : expectedValues) {
            Assertions.assertEquals((Object)funding.getCurrentAmount(), (Object)KualiDecimal.ZERO);
            Assertions.assertEquals((Object)funding.getOutstandingEncumbrance(), (Object)new KualiDecimal(400.0));
        }
    }

    @Test
    void findEmployeeFunding_CurrentFunds() {
        String testFunds = "currentFunds.";
        String testEncumberance = "encumbrance.";
        int numberOfEncumbrance = Integer.parseInt(this.properties.getProperty("encumbrance.numOfExpected"));
        int numberOfCurrentFunds = Integer.parseInt(this.properties.getProperty("currentFunds.numOfExpected"));
        HashMap<String, String> dummyArg = new HashMap<String, String>();
        dummyArg.put("testData", "testData");
        List currentFundsTestData = TestDataPreparator.buildTestDataList(EmployeeFunding.class, (Properties)this.properties, (String)"currentFunds.funding", (String)this.fundingFieldNames, (String)this.deliminator, (int)numberOfCurrentFunds);
        List currentEncumberancesTestData = TestDataPreparator.buildTestDataList(EmployeeFunding.class, (Properties)this.properties, (String)"encumbrance.funding", (String)this.fundingFieldNames, (String)this.deliminator, (int)numberOfEncumbrance);
        Mockito.when((Object)this.laborLedgerBalanceDaoMck.findCurrentEmployeeFunds(dummyArg)).thenReturn((Object)currentFundsTestData);
        Mockito.when((Object)this.laborLedgerBalanceDaoMck.findEncumbranceEmployeeFunds(dummyArg)).thenReturn((Object)currentEncumberancesTestData);
        List expectedValues = this.laborLedgerBalanceServiceImpl.findEmployeeFunding(dummyArg, false);
        for (EmployeeFunding funding : expectedValues) {
            Assertions.assertEquals((Object)funding.getCurrentAmount(), (Object)new KualiDecimal(400.0));
            Assertions.assertEquals((Object)funding.getOutstandingEncumbrance(), (Object)new KualiDecimal(400.0));
        }
    }
}

