/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.ld.service.LaborOriginEntryGroupService;
import org.kuali.kfs.sys.batch.AbstractStep;

import java.util.Date;

public class CreateLaborBackupGroupStep extends AbstractStep {

    private static final Logger LOG = LogManager.getLogger();
    private LaborOriginEntryGroupService laborOriginEntryGroupService;

    /**
     * Invokes the method that creates labor backup group
     *
     * @param jobName    the job running this step
     * @param jobRunDate the time/date when the job was started
     * @return whether the job should continue executing other steps
     */
    @Override
    public boolean execute(final String jobName, final Date jobRunDate) {
        LOG.debug("createLaborBackupGroup() started");
        laborOriginEntryGroupService.createBackupGroup();
        return true;
    }

    public void setLaborOriginEntryGroupService(final LaborOriginEntryGroupService laborOriginEntryGroupService) {
        this.laborOriginEntryGroupService = laborOriginEntryGroupService;
    }
}
