/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.gl.batch.service.VerifyTransaction;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.document.validation.impl.TransactionFieldValidator;
import org.kuali.kfs.sys.Message;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is a validator for the transactions processed by Labor Poster.
 */
public class LaborPosterTransactionValidator implements VerifyTransaction {

    @Override
    public List<Message> verifyTransaction(final Transaction transaction) {
        final List<Message> messageList = new ArrayList<>();
        final LaborTransaction laborTransaction = (LaborTransaction) transaction;

        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkUniversityFiscalYear(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(messageList, TransactionFieldValidator.checkChartOfAccountsCode(laborTransaction));
        CollectionUtils.addIgnoreNull(messageList, TransactionFieldValidator.checkAccountNumber(laborTransaction));
        CollectionUtils.addIgnoreNull(messageList, TransactionFieldValidator.checkSubAccountNumber(laborTransaction,
                        LaborConstants.ANNUAL_CLOSING_DOCUMENT_TYPE_CODE));
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkUniversityFiscalPeriodCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialBalanceTypeCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(messageList, TransactionFieldValidator.checkFinancialObjectCode(laborTransaction));
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialSubObjectCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialObjectTypeCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialDocumentTypeCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialDocumentNumber(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkFinancialSystemOriginationCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkTransactionDebitCreditCode(laborTransaction)
        );
        CollectionUtils.addIgnoreNull(messageList, TransactionFieldValidator.checkEmplid(laborTransaction));
        CollectionUtils.addIgnoreNull(
                messageList,
                TransactionFieldValidator.checkEncumbranceUpdateCode(laborTransaction)
        );

        return messageList;
    }

}
