/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2023 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.gl.businessobject.LedgerBalanceHistory;
import org.kuali.kfs.krad.util.ObjectUtils;

import java.sql.Date;
import java.sql.Timestamp;

/**
 * Labor business object for LedgerBalanceHistory.
 */
public class LaborBalanceHistory extends LedgerBalance implements LedgerBalanceHistory {

    public LaborBalanceHistory() {
        super();
    }

    /**
     * @param laborOriginEntry
     */
    public LaborBalanceHistory(final LaborOriginEntry laborOriginEntry) {
        this();
        setChartOfAccountsCode(laborOriginEntry.getChartOfAccountsCode());
        setAccountNumber(laborOriginEntry.getAccountNumber());
        setFinancialBalanceTypeCode(laborOriginEntry.getFinancialBalanceTypeCode());
        setEmplid(laborOriginEntry.getEmplid());
        setFinancialObjectCode(laborOriginEntry.getFinancialObjectCode());
        setFinancialObjectTypeCode(laborOriginEntry.getFinancialObjectTypeCode());
        setFinancialSubObjectCode(laborOriginEntry.getFinancialSubObjectCode());
        setPositionNumber(laborOriginEntry.getPositionNumber());
        setUniversityFiscalYear(laborOriginEntry.getUniversityFiscalYear());
        setSubAccountNumber(laborOriginEntry.getSubAccountNumber());
    }

    /**
     * Compare amounts
     *
     * @param balance
     * @see org.kuali.kfs.gl.businessobject.Balance#addAmount(java.lang.String, org.kuali.kfs.core.api.util.type.KualiDecimal)
     */
    @Override
    public boolean compareAmounts(final Balance balance) {
        if (!(balance instanceof LedgerBalance)) {
            throw new IllegalArgumentException("balance needs to be of type LedgerBalance");
        }

        final LedgerBalance ledgerBalance = (LedgerBalance) balance;

        return ObjectUtils.isNotNull(ledgerBalance)
                && ledgerBalance.getAccountLineAnnualBalanceAmount().equals(getAccountLineAnnualBalanceAmount())
                && ledgerBalance.getFinancialBeginningBalanceLineAmount()
                    .equals(getFinancialBeginningBalanceLineAmount())
                && ledgerBalance.getContractsGrantsBeginningBalanceAmount()
                    .equals(getContractsGrantsBeginningBalanceAmount())
                && ledgerBalance.getMonth1Amount().equals(getMonth1Amount())
                && ledgerBalance.getMonth2Amount().equals(getMonth2Amount())
                && ledgerBalance.getMonth3Amount().equals(getMonth3Amount())
                && ledgerBalance.getMonth4Amount().equals(getMonth4Amount())
                && ledgerBalance.getMonth5Amount().equals(getMonth5Amount())
                && ledgerBalance.getMonth6Amount().equals(getMonth6Amount())
                && ledgerBalance.getMonth7Amount().equals(getMonth7Amount())
                && ledgerBalance.getMonth8Amount().equals(getMonth8Amount())
                && ledgerBalance.getMonth9Amount().equals(getMonth9Amount())
                && ledgerBalance.getMonth10Amount().equals(getMonth10Amount())
                && ledgerBalance.getMonth11Amount().equals(getMonth11Amount())
                && ledgerBalance.getMonth12Amount().equals(getMonth12Amount())
                && ledgerBalance.getMonth13Amount().equals(getMonth13Amount());
    }

    @Override
    public String getObjectCode() {
        return getFinancialObjectCode();
    }

    @Override
    public void setObjectCode(final String objectCode) {
        setFinancialObjectCode(objectCode);
    }

    @Override
    public String getSubObjectCode() {
        return getFinancialSubObjectCode();
    }

    @Override
    public void setSubObjectCode(final String subObjectCode) {
        setFinancialSubObjectCode(subObjectCode);
    }

    @Override
    public String getObjectTypeCode() {
        return getFinancialObjectTypeCode();
    }

    @Override
    public void setObjectTypeCode(final String objectTypeCode) {
        setFinancialObjectTypeCode(objectTypeCode);
    }

    @Override
    public String getBalanceTypeCode() {
        return getFinancialBalanceTypeCode();
    }

    @Override
    public void setBalanceTypeCode(final String balanceTypeCode) {
        setFinancialBalanceTypeCode(balanceTypeCode);
    }

    /**
     * History does not track this field.
     */
    @Override
    public Date getTimestamp() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTimestamp(final Date timestamp) {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public Timestamp getTransactionDateTimeStamp() {
        throw new UnsupportedOperationException();
    }

    /**
     * History does not track this field.
     */
    @Override
    public void setTransactionDateTimeStamp(final Timestamp transactionDateTimeStamp) {
        throw new UnsupportedOperationException();
    }
}
