/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.util.Date;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.gl.batch.service.PostTransaction;
import org.kuali.kfs.gl.businessobject.Transaction;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborTransaction;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborLedgerBalancePoster
implements PostTransaction {
    private LaborAccountingCycleCachingService laborAccountingCycleCachingService;

    public String post(Transaction transaction, int mode, Date postDate, ReportWriterService posterReportWriterService) {
        String operationType = "insert";
        LedgerBalance ledgerBalance = new LedgerBalance((LaborTransaction)transaction);
        LedgerBalance tempLedgerBalance = this.laborAccountingCycleCachingService.getLedgerBalance(ledgerBalance);
        if (ObjectUtils.isNotNull((Object)((Object)tempLedgerBalance))) {
            ledgerBalance = tempLedgerBalance;
            operationType = "update";
        }
        KualiDecimal amount = transaction.getTransactionLedgerEntryAmount();
        if (transaction.getBalanceType().isFinancialOffsetGenerationIndicator() && !transaction.getTransactionDebitCreditCode().equals(transaction.getObjectType().getFinObjectTypeDebitcreditCd())) {
            amount = (KualiDecimal)amount.negated();
        }
        ledgerBalance.addAmount(transaction.getUniversityFiscalPeriodCode(), amount);
        if (operationType.equals("insert")) {
            this.laborAccountingCycleCachingService.insertLedgerBalance(ledgerBalance);
        } else {
            this.laborAccountingCycleCachingService.updateLedgerBalance(ledgerBalance);
        }
        return operationType;
    }

    public String getDestinationName() {
        return "LD_LDGR_BAL_T";
    }

    public void setLaborAccountingCycleCachingService(LaborAccountingCycleCachingService laborAccountingCycleCachingService) {
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
    }
}

